<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AlmacenamientoInsumo extends Model
{
    use HasFactory;

    protected $table = 'almacenamientos_insumos';

    protected $fillable = [
        'internal_inspection_id',
        'almacenamiento_insumos_bodega_especial',
        'almacenamiento_insumos_almacenamiento_exclusivo',
        'almacenamiento_insumos_prevencion_contaminacion_almacenamiento',
        'almacenamiento_insumos_riesgos_mezcla_producto',
        'almacenamiento_insumos_prevencion_plagas_almacen',
        'almacenamiento_insumos_prevencion_plagas_almacen_describir',
        'almacenamiento_insumos_envases_exclusivos',
        'almacenamiento_insumos_riegos_costales',
    ];

    //Relación con internal_inspection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
