<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AreaGeneral extends Model
{
    use HasFactory;

    protected $table = 'areas_generales';

    protected $fillable = [
        'internal_inspection_id',
        'area_general_tiene_area_autoconsumo',
        'area_general_area_autoconsumo',
        'area_general_autoconsumo_n_parcelas',
        'area_general_autoconsumo_quimicos',
        'area_general_autoconsumo_fecha_quimicos',
        'area_general_tiene_area_potrero',
        'area_general_area_potrero',
        'area_general_potrero_n_parcelas',
        'area_general_tiene_area_bosque',
        'area_general_area_bosque',
        'area_general_bosque_n_parcelas',
        'area_general_tiene_area_acahual',
        'area_general_area_acahual',
        'area_general_acahual_n_parcelas',
    ];

    protected $casts = [
        'area_general_area_autoconsumo' => 'decimal:2',
        'area_general_autoconsumo_n_parcelas' => 'integer',
        'area_general_autoconsumo_fecha_quimicos' => 'date',
        'area_general_tiene_area_potrero' => 'decimal:2',
        'area_general_area_bosque' => 'decimal:2',
        'area_general_bosque_n_parcelas' => 'integer',
        'area_general_area_acahual' => 'decimal:2',
        'area_general_acahual_n_parcelas' => 'integer',
    ];

    //Relación con internal_ispection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
