<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BeneficioHumedo extends Model
{
    use HasFactory;

    protected $table = 'beneficios_humedos';

    protected $fillable = [
        'internal_inspection_id',
        'beneficio_humedo_bh_fermentacion',
        'beneficio_humedo_bh_fuente_agua_lavado',
        'beneficio_humedo_bh_lavado_agua_potable',
        'beneficio_humedo_bh_destino_agua_miel',
        'beneficio_humedo_bh_despulpadora_tipo',
        'beneficio_bh_despulpadora_exclusiva',
        'beneficio_humedo_bh_destino_pulpa',
        'beneficio_humedo_bh_secado',
        'beneficio_humedo_bh_riesgo_contaminacion',
        'beneficio_humedo_bh_riesgo_contaminacion_area',
        'beneficio_humedo_bh_riesgos_mezcla_producto',
        'beneficio_humedo_bh_instalaciones_compartidas',
        'beneficio_humedo_bh_medidas_prevencion',
    ];

    //Relación con internal inspection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
