<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Capacitacion extends Model
{
    use HasFactory;

    protected $table = 'capacitaciones';

    protected $fillable = [
        'internal_inspection_id',
        'capacitaciones_cap_capacitaciones',
        'capacitaciones_cap_programa_individual',
        'capacitaciones_cap_registro_promotor',
        'capacitaciones_cap_capacitacion_recibida',
        'capacitaciones_cap_capacitacion_fecha',
        'capacitaciones_cap_capacitacion_temas',
        'capacitaciones_cap_practica_plan_manejo_organico',
        'capacitaciones_cap_conoce_insumos_permitidos',
        'capacitaciones_cap_conoce_reglamento_interno',
        'capacitaciones_cap_recibos_ventas',
        'capacitaciones_conocimiento_premio_social',
        'capacitaciones_recibe_premio_social',
        'capacitaciones_uso_premio_social',
    ];

    protected $casts = [
        'capacitaciones_cap_capacitacion_fecha' => 'date',
    ];

    //Relación con Internal_Inpection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
