<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CosechaAcopio extends Model
{
    use HasFactory;

    protected $table = 'cosechas_acopio';

    protected $fillable = [
        'parcela_id',
        // Aspecto de las plantas
        'aspecto_nivel1',
        'aspecto_nivel2',
        'aspecto_nivel3',
        // Número de plantas
        'n_plantas_n1',
        'n_plantas_n2',
        'n_plantas_n3',
        'n_plantas_tot',
        // Edad y plantillas
        'edad_plantas',
        'plantillas',
        'plantillas_numero',
        // Producción
        'kg_pergamino_n1',
        'kg_pergamino_n2',
        'kg_pergamino_n3',
        'kg_pergamino_tot',
        // Campos específicos de parcela 1
        'condiciones_productivas',
        'entrega_cafe',
        'venta_otro_productor',
        'otro_productor',
        'fecha_cosecha_organico',
    ];

    protected $casts = [
        'n_plantas_n1' => 'integer',
        'n_plantas_n2' => 'integer',
        'n_plantas_n3' => 'integer',
        'n_plantas_tot' => 'integer',
        'edad_plantas' => 'integer',
        'plantillas_numero' => 'integer',
        'kg_pergamino_n1' => 'decimal:2',
        'kg_pergamino_n2' => 'decimal:2',
        'kg_pergamino_n3' => 'decimal:2',
        'kg_pergamino_tot' => 'decimal:2',
        'fecha_cosecha_organico' => 'date',
    ];

    //Relación con parcela
    public function parcela()
    {
        return $this->belongsTo(Parcela::class, 'parcela_id');
    }
}
