<?php

namespace App\Models;

use MongoDB\Laravel\Eloquent\Model;
use Carbon\Carbon;

class Inspeccion extends Model
{
    protected $connection = 'mongodb';
    protected $collection = 'inspecciones';
    
    protected $fillable = [
        // Metadatos de KoboToolbox
        'kobo_id',
        'submission_time',
        'submitted_by',
        'uuid',
        'meta_instance_id',
        'meta_rootUuid',
        'meta_instanceName',
        'meta_deprecatedID',
        'xform_id_string',
        'version',
        'status',
        'geolocation',
        'tags',
        'notes',
        'validation_status',
        'attachments',
        
        // Campos de sistema
        'starttime',
        'endtime',
        'start',
        'end',
        'today',
        'username',
        'deviceid',
        'phonenumber',
        'p_nombre',
        'ciclo_codigo',
        'subscriberid',
        'simid',
        'id_record',
        'hora',
        'horas',
        'minutos',
        'segundos',
        'anos',
        'mes',
        'dias',
        
        // Información General
        'fecha_visita',
        'hora_inicio',
        'inspector',
        'gps_productor',
        'productor_nuevo',
        'otra_organizacion',
        'nombre_otra_organizacion',
        
        // Datos del Productor
        'dni',
        'id_inspeccion',
        'socio',
        'curp',
        'rfc',
        'ine',
        'folio_cafetalero',
        'folio_suri',
        'municipio',
        'localidad',
        'grupo_trabajo',
        'telefono',
        'genero',
        'fecha_nacimiento',
        'fecha_ingreso',
        'estatus',
        'fecha_transicion',
        'baja_productor',
        'tenencia_tierra',
        'titulo_tenencia',
        'papel_tenencia',
        'participa_otra_organizacion',
        'producto_otra_organizacion',
        'nombre_otra_organizacion_001',
        'familia_participa_otra_organizacion',
        'familia_producto_otra_organizazacion',
        'familia_otra_organizacion',
        'familia_categoria_otra_organizacion',
        
        // Área General
        'tiene_area_autoconsumo',
        'area_autoconsumo',
        'autoconsumo_n_parcelas',
        'autoconsumo_quimicos',
        'autoconsumo_fecha_quimicos',
        'tiene_area_potrero',
        'area_potrero',
        'potrero_n_parcelas',
        'tiene_area_bosque',
        'area_bosque',
        'bosque_n_parcelas',
        'tiene_area_acahual',
        'area_acahual',
        'acahual_n_parcelas',
        
        // Semillero y Vivero
        'sem_semillero',
        'sem_numero_semilleros',
        'sem_semillas_organicas',
        'sem_proveniencia_semillas',
        'variedades_semillas',
        'sem_control_plagas',
        'sem_aplica_producto_quimico',
        'sem_producto_quimico',
        'sem_fecha_aplicacion_quimico',
        'sem_aplica_preparado',
        'sem_preparado',
        'sem_fecha_aplicacion_preparado',
        
        // Abonera
        'p1_abono_organico',
        'p1_tipo_abono_organico',
        'p1_foto_abono_organico',
        'p1_plantas_abono_organico',
        'p1_kilos_litros_abono_composta',
        'p1_kilos_planta_composta',
        'p1_cuantos_litros_lixiviado_lombricomposta',
        'p1_plantas_foliar_lombricomposta',
        'p1_donde_aplico_composta',
        'p1_composta_vivero',
        'p1_composta_vivero_bolsas',
        'p1_compra_abono_organico',
        'p1_compra_abono_cumplimiento',
        'p1_cosecha_abono',
        'p1_plantas_abonadas',
        'p1_aplica_estiercol_crudo',
        'p1_estiercol_crudo_plantas',
        'p1_estiercol_crudo_kg',
        
        // Beneficio Húmedo
        'bh_fermentacion',
        'bh_fuente_agua_lavado',
        'bh_lavado_agua_potable',
        'bh_destino_agua_miel',
        'bh_despulpadora_tipo',
        'bh_despulpadora_exclusiva',
        'bh_destino_pulpa',
        'bh_secado',
        'bh_riesgo_contaminacion',
        'bh_riesgo_contaminacion_area',
        'bh_riesgos_mezcla_producto',
        'bh_instalaciones_compartidas',
        'bh_medidas_prevencion',
        
        // Almacenamiento
        'bodega_especial',
        'almacenamiento_exclusivo',
        'prevencion_contaminacion_almacenamiento',
        'riesgos_mezcla_producto',
        'prevencion_plagas_almacen',
        'prevencion_plagas_almacen_describir',
        'envases_exclusivos',
        'riegos_costales',
        
        // Capacitaciones
        'cap_capacitaciones',
        'cap_programa_individual',
        'cap_registro_promotor',
        'cap_capacitacion_recibida',
        'cap_capacitacion_fecha',
        'cap_capacitacion_temas',
        'cap_practica_plan_manejo_organico',
        'cap_conoce_insumos_permitidos',
        'cap_conoce_reglamento_interno',
        'cap_recibos_ventas',
        'conocimiento_premio_social',
        'recibe_premio_social',
        'uso_premio_social',
        
        // Información de Parcelas
        'n_parcelas',
        'parcela_nueva',
        'parcela_adicional_suma',
        
        // Parcelas (array de objetos)
        'parcelas',
        
        // Control de Plagas General
        'control_plagas',
        'insumos_plagas_seleccionados',
        'control_plagas_fecha',
        'insumos_aprobados',
        'aspersora',
        
        // Conservación
        'conservacion_agua',
        'conservacion_agua_actividades',
        'aplica_ceniza',
        'ceniza_plantas',
        'ceniza_kg',
        'ceniza_origen',
        'ceniza_tratada',
        
        // Basura
        'basura_inorganica',
        
        // Cosecha y Comercialización
        'fecha_cosecha_organico',
        'entrega_cafe',
        'procesamiento',
        'venta_otro_productor',
        'otro_productor',
        
        // Resumen
        'parcelas_totales',
        'area_total',
        'plantas_totales',
        'plantillas_totales',
        'kg_estimados_totales',
        'kg_cosecha_pasada',
        'observaciones_generales',
        
        // Comprobación
        'razon_baja',
        'firma_insp',
        'firma_socio',
        'hora_final',
        
        // Raw data completo
        'raw_data'
    ];

    protected $casts = [
        'parcelas' => 'array',
        'raw_data' => 'array',
        'attachments' => 'array',
        'geolocation' => 'array',
        'tags' => 'array',
        'notes' => 'array',
        'validation_status' => 'array',
        'submission_time' => 'datetime',
        'starttime' => 'datetime',
        'endtime' => 'datetime',
        'fecha_visita' => 'date',
        'fecha_nacimiento' => 'date',
        'fecha_ingreso' => 'date',
        'fecha_transicion' => 'date',
        'fecha_cosecha_organico' => 'date',
        'cap_capacitacion_fecha' => 'date',
        'autoconsumo_fecha_quimicos' => 'date',
        'sem_fecha_aplicacion_quimico' => 'date',
        'sem_fecha_aplicacion_preparado' => 'date',
        'control_plagas_fecha' => 'date',
        'parcelas' => 'array',  // IMPORTANTE: Decodificar JSON de parcelas
        'tenencia_tierra' => 'array',
        'variedades_semillas' => 'array',
        'cap_capacitacion_temas' => 'array',
        'prevencion_contaminacion_almacenamiento' => 'array',
        'insumos_plagas_seleccionados' => 'array',
        'conservacion_agua_actividades' => 'array',
        'entrega_cafe' => 'array',
    ];

    protected $dates = [
        'fecha_visita',
        'fecha_nacimiento',
        'fecha_ingreso',
        'fecha_transicion',
        'submission_time',
        'created_at',
        'updated_at'
    ];

    public $timestamps = true;

    // Accesor para formatear fechas
    public function getFechaVisitaFormattedAttribute()
    {
        return $this->fecha_visita ? $this->fecha_visita->format('d/m/Y') : null;
    }

    public function getSubmissionTimeFormattedAttribute()
    {
        return $this->submission_time ? $this->submission_time->format('d/m/Y H:i') : null;
    }
    

    /**
     * Obtener el estado del productor
     */
    public function getEstadoAttribute()
    {
        return $this->baja_productor === 'si' ? 'Inactivo' : 'Activo';
    }

    /**
     * Obtener el número de parcelas activas
     */
    public function getParcelasActivasAttribute()
    {
        if (!$this->parcelas) {
            return 0;
        }
        
        return collect($this->parcelas)
            ->where('activa', '0') // '0' significa activa en el formulario
            ->count();
    }

    /**
     * Obtener área total de parcelas activas
     */
    public function getAreaTotalActivaAttribute()
    {
        if (!$this->parcelas) {
            return 0;
        }
        
        return collect($this->parcelas)
            ->where('activa', '0')
            ->sum('superficie');
    }

    /**
     * Scope para filtrar por año
     */
    public function scopeByYear($query, $year)
    {
        return $query->whereYear('fecha_visita', $year);
    }

    /**
     * Scope para filtrar por inspector
     */
    public function scopeByInspector($query, $inspector)
    {
        return $query->where('inspector', $inspector);
    }

     // Scope para filtrar por municipio
    public function scopeByMunicipio($query, $municipio)
    {
        if ($municipio) {
            return $query->where('municipio', $municipio);
        }
        return $query;
    }

    // Scope para filtrar por estatus
    public function scopeByEstatus($query, $estatus)
    {
        if ($estatus) {
            return $query->where('estatus', $estatus);
        }
        return $query;
    }

    /**
     * Scope para productores activos
     */
    public function scopeActivos($query)
    {
        return $query->where(function($q) {
            $q->where('baja_productor', '!=', 'si')
              ->orWhereNull('baja_productor');
        });
    }

    /**
     * Scope para productores dados de baja
     */
    public function scopeBaja($query)
    {
        return $query->where('baja_productor', 'si');
    }
}