<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;


class InternalInspection extends Model
{
    use HasFactory;

    protected $table = 'internal_inspections';

    protected $fillable = [
        // Datos base
        '_id',
        'starttime',
        'endtime',
        'today',
        'deviceid',
        'p_nombre',
        'ciclo_codigo',
        'hora',
        'horas',
        'minutos',
        'segundos',
        'anos',
        'mes',
        'dias',
        'subscriberid',
        'simid',
        'id_record',

        // Info general
        'info_general_fecha_visita',
        'info_general_hora_inicio',
        'info_general_inspector',

        // Productor
        'productor_dni',
        'productor_id_inspeccion',
        'productor_dni_o',
        'productor_socio',
        'productor_curp',
        'productor_rfc',
        'productor_ine',
        'productor_folio_cafetalero',
        'productor_folio_suri',
        'productor_municipio',
        'productor_localidad',
        'productor_grupo_trabajo',
        'productor_telefono',
        'productor_genero',
        'productor_fecha_nacimiento',
        'productor_fecha_ingreso',
        'productor_estatus',
        'productor_fecha_transicion',
        'productor_baja_productor',
        'productor_tenencia_tierra',
        'productor_titulo_tenencia',
        'productor_papel_tenencia',
        'productor_participa_otra_organizacion',
        'productor_producto_otra_organizazacion',
        'productor_nombre_otra_organizacion_001',
        'productor_familia_participa_otra_organizacion',
        'productor_familia_producto_otra_organizazacion',
        'productor_familia_otra_organizacion',
        'productor_familia_categoria_otra_organizacion',

        // Area general
        'area_general_tiene_area_autoconsumo',
        'area_general_area_autoconsumo',
        'area_general_autoconsumo_n_parcelas',
        'area_general_autoconsumo_quimicos',
        'area_general_autoconsumo_fecha_quimicos',
        'area_general_tiene_area_potrero',
        'area_general_area_potrero',
        'area_general_potrero_n_parcelas',
        'area_general_tiene_area_bosque',
        'area_general_area_bosque',
        'area_general_bosque_n_parcelas',
        'area_general_tiene_area_acahual',
        'area_general_area_acahual',
        'area_general_acahual_n_parcelas',

        // Semillero vivero
        'semillero_vivero_sem_semillero',
        'semillero_vivero_sem_numero_semilleros',
        'semillero_vivero_sem_semillas_organicas',
        'semillero_vivero_sem_proveniencia_semillas',
        'semillero_vivero_variedades_semillas',
        'semillero_vivero_sem_control_plagas',
        'semillero_vivero_sem_aplica_producto_quimico',
        'semillero_vivero_sem_producto_quimico',
        'semillero_vivero_sem_fecha_aplicacion_quimico',
        'semillero_vivero_sem_aplica_preparado',
        'semillero_vivero_sem_preparado',
        'semillero_vivero_sem_fecha_aplicacion_preparado',

        // Abonera
        'abonera_p1_abono_organico',
        'abonera_p1_tipo_abono_organico',
        'abonera_p1_foto_abono_organico',
        'abonera_p1_plantas_abono_organico',
        'abonera_p1_kilos_litros_abono_composta',
        'abonera_p1_kilos_planta_composta',
        'abonera_p1_cuantos_litros_lixiviado_lombricomposta',
        'abonera_p1_plantas_foliar_lombricomposta',
        'abonera_p1_donde_aplico_composta',
        'abonera_p1_composta_vivero',
        'abonera_p1_composta_vivero_bolsas',
        'abonera_p1_compra_abono_organico',
        'abonera_p1_compra_abono_cumplimiento',
        'abonera_p1_cosecha_abono',
        'abonera_p1_plantas_abonadas',
        'abonera_p1_aplica_estiercol_crudo',
        'abonera_p1_estiercol_crudo_plantas',
        'abonera_p1_estiercol_crudo_kg',

        // Beneficio Humedo
        'beneficio_humedo_bh_fermentacion',
        'beneficio_humedo_bh_fuente_agua_lavado',
        'beneficio_humedo_bh_lavado_agua_potable',
        'beneficio_humedo_bh_destino_agua_miel',
        'beneficio_humedo_bh_despulpadora_tipo',
        'beneficio_bh_despulpadora_exclusiva',
        'beneficio_humedo_bh_destino_pulpa',
        'beneficio_humedo_bh_secado',
        'beneficio_humedo_bh_riesgo_contaminacion',
        'beneficio_humedo_bh_riesgo_contaminacion_area',
        'beneficio_humedo_bh_riesgos_mezcla_producto',
        'beneficio_humedo_bh_instalaciones_compartidas',
        'beneficio_humedo_bh_medidas_prevencion',

        // Almacenamiento insumos
        'almacenamiento_insumos_bodega_especial',
        'almacenamiento_insumos_almacenamiento_exclusivo',
        'almacenamiento_insumos_prevencion_contaminacion_almacenamiento',
        'almacenamiento_insumos_riesgos_mezcla_producto',
        'almacenamiento_insumos_prevencion_plagas_almacen',
        'almacenamiento_insumos_prevencion_plagas_almacen_describir',
        'almacenamiento_insumos_envases_exclusivos',
        'almacenamiento_insumos_riegos_costales',

        // Capacitación
        'capacitaciones_cap_capacitaciones',
        'capacitaciones_cap_programa_individual',
        'capacitaciones_cap_registro_promotor',
        'capacitaciones_cap_capacitacion_recibida',
        'capacitaciones_cap_capacitacion_fecha',
        'capacitaciones_cap_capacitacion_temas',
        'capacitaciones_cap_practica_plan_manejo_organico',
        'capacitaciones_cap_conoce_insumos_permitidos',
        'capacitaciones_cap_conoce_reglamento_interno',
        'capacitaciones_cap_recibos_ventas',
        'capacitaciones_conocimiento_premio_social',
        'capacitaciones_recibe_premio_social',
        'capacitaciones_uso_premio_social',

        // Información de parcelas
        'num_parcelas_dni_p',
        'num_parcelas_n_parcelas',
        'num_parcelas_parcela_nueva',
        'num_parcelas_parcela_adicional_suma_t',
        'num_parcelas_parcela_adicional_suma',
        'num_parcelas_p1_cod',
        'num_parcelas_p2_cod',
        'num_parcelas_p3_cod',
        'num_parcelas_p4_cod',
        'num_parcelas_p5_cod',
        'num_parcelas_p6_cod',
        'num_parcelas_p7_cod',
        'num_parcelas_p8_cod',
        'num_parcelas_p9_cod',
        'num_parcelas_p1_ex',
        'num_parcelas_p2_ex',
        'num_parcelas_p3_ex',
        'num_parcelas_p4_ex',
        'num_parcelas_p5_ex',
        'num_parcelas_p6_ex',
        'num_parcelas_p7_ex',
        'num_parcelas_p8_ex',
        'num_parcelas_p9_ex',

        // Parcela 1 (todos los campos)
        'parcela_1_p1_cod_1',
        'parcela_1_p1_nombre',
        'parcela_1_p1_codigo',
        'parcela_1_p1_area_ant',
        'parcela_1_p1_activa',
        'parcela_1_p1_variacion_parcela',
        'parcela_1_p1_area_actual',
        'parcela_1_p1_variacion_explicacion',
        'parcela_1_p1_area_x',
        'parcela_1_p1_area',
        'parcela_1_p1_variedades',
        'parcela_1_p1_tipo_sombra',
        'parcela_1_p1_estado_sombra',
        'parcela_1_p1_arboles_altos',
        'parcela_1_p1_arboles_altos_numero',
        'parcela_1_p1_talas_inecesaria',
        'parcela_1_p1_renovacion_sombras',
        'parcela_1_p1_colindante_talas',
        'parcela_1_p1_materia_organica',
        'parcela_1_p1_cobertura',
        'parcela_1_p1_deslavado',
        'parcela_1_p1_practicas_conservacion',
        'parcela_1_p1_barreras_vivas',
        'parcela_1_p1_metros_barreras_vivas',
        'parcela_1_p1_terrazas',
        'parcela_1_p1_numero_terrazas',
        'parcela_1_p1_mantemimiento',
        'parcela_1_p1_mantenimiento_descripcion',
        'parcela_1_p1_podas',
        'parcela_1_p1_podas_descripcion',
        'parcela_1_p1_plagas_enfermedades',
        'parcela_1_control_plagas',
        'parcela_1_insumos_control_plagas',
        'parcela_1_insumos_plagas_seleccionados',
        'parcela_1_insumos_control_plagas_fecha',
        'parcela_1_insumos_insumos_aprobados',
        'parcela_1_aspersora',
        'parcela_1_p1_aplica_quimico',
        'parcela_1_p1_producto_quimico',
        'parcela_1_p1_fecha_producto_quimico',
        'parcela_1_p1_condiciones',
        'parcela_1_p1_basura',
        'parcela_1_basura_inorganica',
        'parcela_1_conservacion_agua',
        'parcela_1_conservacion_agua_actividades',
        'parcela_1_aplica_ceniza',
        'parcela_1_ceniza_plantas',
        'parcela_1_ceniza_kg',
        'parcela_1_ceniza_origen',
        'parcela_1_ceniza_tratada',
        'parcela_1_p1_riesgo',
        'parcela_1_p1_observaciones',

        // Terrenos colindantes P1
        'terrenos_colindantes_entorno_p1_cod_1c',
        'terrenos_colindantes_entorno_p1_norte',
        'terrenos_colindantes_entorno_p1_norte_propietario',
        'terrenos_colindantes_entorno_p1_sur',
        'terrenos_colindantes_entorno_p1_sur_propietario',
        'terrenos_colindantes_entorno_p1_este',
        'terrenos_colindantes_entorno_p1_este_propietario',
        'terrenos_colindantes_entorno_p1_oeste',
        'terrenos_colindantes_entorno_p1_oeste_propietario',
        'terrenos_colindantes_entorno_p1_herbicidas_colindantes',
        'terrenos_colindantes_entorno_p1_nombre_herbicida_colindante',
        'terrenos_colindantes_entorno_p1_riesgos_contaminacion',
        'terrenos_colindantes_entorno_p1_lado_riesgos_contaminacion',
        'terrenos_colindantes_entorno_p1_franja_amortiguamiento',
        'terrenos_colindantes_entorno_p1_zanja',
        'terrenos_colindantes_entorno_p1_barreras_vivas_001',
        'terrenos_colindantes_entorno_p1_ninguna_evita_contaminacion',
        'terrenos_colindantes_entorno_p1_glifosato',
        'terrenos_colindantes_entorno_p1_aplicacion_glifosato',
        'terrenos_colindantes_entorno_p1_aplicacion_glifosato_metros',

        // Cosecha P1
        'cosecha_acopio_comercializacion_fecha_cosecha_organico',
        'cosecha_acopio_comercializacion_p1_aspecto_nivel1',
        'cosecha_acopio_comercializacion_p1_aspecto_nivel2',
        'cosecha_acopio_comercializacion_p1_aspecto_nivel3',
        'cosecha_acopio_comercializacion_p1_n_plantas_n1',
        'cosecha_acopio_comercializacion_p1_n_plantas_n2',
        'cosecha_acopio_comercializacion_p1_n_plantas_n3',
        'cosecha_acopio_comercializacion_p1_n_plantas_tot',
        'cosecha_acopio_comercializacion_p1_edad_plantas',
        'cosecha_acopio_comercializacion_p1_plantillas',
        'cosecha_acopio_comercializacion_p1_plantillas_numero',
        'cosecha_acopio_comercializacion_p1_kg_pergamino_n1',
        'cosecha_acopio_comercializacion_p1_kg_pergamino_n2',
        'cosecha_acopio_comercializacion_p1_kg_pergamino_n3',
        'cosecha_acopio_comercializacion_p1_kg_pergamino_tot',
        'cosecha_acopio_comercializacion_p1_condiciones_productivas',
        'cosecha_acopio_comercializacion_entrega_cafe',
        'cosecha_acopio_comercializacion_venta_otro_productor',
        'cosecha_acopio_comercializacion_otro_productor',

        // PARCELA 2
        'parcela_2_p2_cod_2',
        'parcela_2_p2_nombre',
        'parcela_2_p2_codigo',
        'parcela_2_p2_area_ant',
        'parcela_2_p2_activa',
        'parcela_2_p2_variacion_parcela',
        'parcela_2_p2_area_actual',
        'parcela_2_p2_variacion_explicacion',
        'parcela_2_p2_area_x',
        'parcela_2_p2_area',
        'parcela_2_p2_variedades',
        'parcela_2_p2_tipo_sombra',
        'parcela_2_p2_estado_sombra',
        'parcela_2_p2_arboles_altos',
        'parcela_2_p2_arboles_altos_numero',
        'parcela_2_p2_talas_inecesaria',
        'parcela_2_p2_renovacion_sombras',
        'parcela_2_p2_colindante_talas',
        'parcela_2_p2_materia_organica',
        'parcela_2_p2_cobertura',
        'parcela_2_p2_deslavado',
        'parcela_2_p2_practicas_conservacion',
        'parcela_2_p2_barreras_vivas',
        'parcela_2_p2_metros_barreras_vivas',
        'parcela_2_p2_terrazas',
        'parcela_2_p2_numero_terrazas',
        'parcela_2_p2_mantemimiento',
        'parcela_2_p2_mantenimiento_descripcion',
        'parcela_2_p2_aplica_estiercol_crudo',
        'parcela_2_p2_estiercol_crudo_plantas',
        'parcela_2_p2_estiercol_crudo_kg',
        'parcela_2_p2_podas',
        'parcela_2_p2_podas_descripcion',
        'parcela_2_p2_plagas_enfermedades',
        'parcela_2_p2_aplica_quimico',
        'parcela_2_p2_producto_quimico',
        'parcela_2_p2_fecha_producto_quimico',
        'parcela_2_p2_condiciones',
        'parcela_2_p2_basura',
        'parcela_2_p2_riesgo',
        'parcela_2_p2_observaciones',

        // Terrenos colindantes P2
        'p2_terrenos_p2_cod_2c',
        'p2_terrenos_p2_norte',
        'p2_terrenos_p2_norte_propietario',
        'p2_terrenos_p2_sur',
        'p2_terrenos_p2_sur_propietario',
        'p2_terrenos_p2_este',
        'p2_terrenos_p2_este_propietario',
        'p2_terrenos_p2_oeste',
        'p2_terrenos_p2_oeste_propietario',
        'p2_terrenos_p2_herbicidas_colindantes',
        'p2_terrenos_p2_nombre_herbicida_colindante',
        'p2_terrenos_p2_riesgos_contaminacion',
        'p2_terrenos_p2_lado_riesgos_contaminacion',
        'p2_terrenos_p2_franja_amortiguamiento',
        'p2_terrenos_p2_zanja',
        'p2_terrenos_p2_barreras_vivas_001',
        'p2_terrenos_p2_ninguna_evita_contaminacion',
        'p2_terrenos_p2_glifosato',
        'p2_terrenos_p2_aplicacion_glifosato',
        'p2_terrenos_p2_aplicacion_glifosato_metros',

        // Cosecha P2
        'p2_cosecha_p2_aspecto_nivel1',
        'p2_cosecha_p2_aspecto_nivel2',
        'p2_cosecha_p2_aspecto_nivel3',
        'p2_cosecha_p2_n_plantas_n1',
        'p2_cosecha_p2_n_plantas_n2',
        'p2_cosecha_p2_n_plantas_n3',
        'p2_cosecha_p2_n_plantas_tot',
        'p2_cosecha_p2_edad_plantas',
        'p2_cosecha_p2_plantillas',
        'p2_cosecha_p2_plantillas_numero',
        'p2_cosecha_p2_kg_pergamino_n1',
        'p2_cosecha_p2_kg_pergamino_n2',
        'p2_cosecha_p2_kg_pergamino_n3',
        'p2_cosecha_p2_kg_pergamino_tot',

         // PARCELA 3
        'parcela_3_p3_cod_3',
        'parcela_3_p3_nombre',
        'parcela_3_p3_codigo',
        'parcela_3_p3_area_ant',
        'parcela_3_p3_activa',
        'parcela_3_p3_variacion_parcela',
        'parcela_3_p3_area_actual',
        'parcela_3_p3_variacion_explicacion',
        'parcela_3_p3_area_x',
        'parcela_3_p3_area',
        'parcela_3_p3_variedades',
        'parcela_3_p3_tipo_sombra',
        'parcela_3_p3_estado_sombra',
        'parcela_3_p3_arboles_altos',
        'parcela_3_p3_arboles_altos_numero',
        'parcela_3_p3_talas_inecesaria',
        'parcela_3_p3_renovacion_sombras',
        'parcela_3_p3_colindante_talas',
        'parcela_3_p3_materia_organica',
        'parcela_3_p3_cobertura',
        'parcela_3_p3_deslavado',
        'parcela_3_p3_practicas_conservacion',
        'parcela_3_p3_barreras_vivas',
        'parcela_3_p3_metros_barreras_vivas',
        'parcela_3_p3_terrazas',
        'parcela_3_p3_numero_terrazas',
        'parcela_3_p3_mantemimiento',
        'parcela_3_p3_mantenimiento_descripcion',
        'parcela_3_p3_aplica_estiercol_crudo',
        'parcela_3_p3_estiercol_crudo_plantas',
        'parcela_3_p3_estiercol_crudo_kg',
        'parcela_3_p3_podas',
        'parcela_3_p3_podas_descripcion',
        'parcela_3_p3_plagas_enfermedades',
        'parcela_3_p3_aplica_quimico',
        'parcela_3_p3_producto_quimico',
        'parcela_3_p3_fecha_producto_quimico',
        'parcela_3_p3_condiciones',
        'parcela_3_p3_basura',
        'parcela_3_p3_riesgo',
        'parcela_3_p3_observaciones',

        //Terrenos colindantes P3
        'p3_terrenos_p3_cod_3c',
        'p3_terrenos_p3_norte',
        'p3_terrenos_p3_norte_propietario',
        'p3_terrenos_p3_sur',
        'p3_terrenos_p3_sur_propietario',
        'p3_terrenos_p3_este',
        'p3_terrenos_p3_este_propietario',
        'p3_terrenos_p3_oeste',
        'p3_terrenos_p3_oeste_propietario',
        'p3_terrenos_p3_herbicidas_colindantes',
        'p3_terrenos_p3_nombre_herbicida_colindante',
        'p3_terrenos_p3_riesgos_contaminacion',
        'p3_terrenos_p3_lado_riesgos_contaminacion',
        'p3_terrenos_p3_franja_amortiguamiento',
        'p3_terrenos_p3_zanja',
        'p3_terrenos_p3_barreras_vivas_001',
        'p3_terrenos_p3_ninguna_evita_contaminacion',
        'p3_terrenos_p3_glifosato',
        'p3_terrenos_p3_aplicacion_glifosato',
        'p3_terrenos_p3_aplicacion_glifosato_metros',

        //Cosecha P3
        'p3_cosecha_p3_aspecto_nivel1',
        'p3_cosecha_p3_aspecto_nivel2',
        'p3_cosecha_p3_aspecto_nivel3',
        'p3_cosecha_p3_n_plantas_n1',
        'p3_cosecha_p3_n_plantas_n2',
        'p3_cosecha_p3_n_plantas_n3',
        'p3_cosecha_p3_n_plantas_tot',
        'p3_cosecha_p3_edad_plantas',
        'p3_cosecha_p3_plantillas',
        'p3_cosecha_p3_plantillas_numero',
        'p3_cosecha_p3_kg_pergamino_n1',
        'p3_cosecha_p3_kg_pergamino_n2',
        'p3_cosecha_p3_kg_pergamino_n3',
        'p3_cosecha_p3_kg_pergamino_tot',

        // PARCELA 4
        'parcela_4_p4_cod_4',
        'parcela_4_p4_nombre',
        'parcela_4_p4_codigo',
        'parcela_4_p4_area_ant',
        'parcela_4_p4_activa',
        'parcela_4_p4_variacion_parcela',
        'parcela_4_p4_area_actual',
        'parcela_4_p4_variacion_explicacion',
        'parcela_4_p4_area_x',
        'parcela_4_p4_area',
        'parcela_4_p4_variedades',
        'parcela_4_p4_tipo_sombra',
        'parcela_4_p4_estado_sombra',
        'parcela_4_p4_arboles_altos',
        'parcela_4_p4_arboles_altos_numero',
        'parcela_4_p4_talas_inecesaria',
        'parcela_4_p4_renovacion_sombras',
        'parcela_4_p4_colindante_talas',
        'parcela_4_p4_materia_organica',
        'parcela_4_p4_cobertura',
        'parcela_4_p4_deslavado',
        'parcela_4_p4_practicas_conservacion',
        'parcela_4_p4_barreras_vivas',
        'parcela_4_p4_metros_barreras_vivas',
        'parcela_4_p4_terrazas',
        'parcela_4_p4_numero_terrazas',
        'parcela_4_p4_mantemimiento',
        'parcela_4_p4_mantenimiento_descripcion',
        'parcela_4_p4_aplica_estiercol_crudo',
        'parcela_4_p4_estiercol_crudo_plantas',
        'parcela_4_p4_estiercol_crudo_kg',
        'parcela_4_p4_podas',
        'parcela_4_p4_podas_descripcion',
        'parcela_4_p4_plagas_enfermedades',
        'parcela_4_p4_aplica_quimico',
        'parcela_4_p4_producto_quimico',
        'parcela_4_p4_fecha_producto_quimico',
        'parcela_4_p4_condiciones',
        'parcela_4_p4_basura',
        'parcela_4_p4_riesgo',
        'parcela_4_p4_observaciones',
        //Terrenos colindantes P4
        'p4_terrenos_p4_cod_4c',
        'p4_terrenos_p4_norte',
        'p4_terrenos_p4_norte_propietario',
        'p4_terrenos_p4_sur',
        'p4_terrenos_p4_sur_propietario',
        'p4_terrenos_p4_este',
        'p4_terrenos_p4_este_propietario',
        'p4_terrenos_p4_oeste',
        'p4_terrenos_p4_oeste_propietario',
        'p4_terrenos_p4_herbicidas_colindantes',
        'p4_terrenos_p4_nombre_herbicida_colindante',
        'p4_terrenos_p4_riesgos_contaminacion',
        'p4_terrenos_p4_lado_riesgos_contaminacion',
        'p4_terrenos_p4_franja_amortiguamiento',
        'p4_terrenos_p4_zanja',
        'p4_terrenos_p4_barreras_vivas_001',
        'p4_terrenos_p4_ninguna_evita_contaminacion',
        'p4_terrenos_p4_glifosato',
        'p4_terrenos_p4_aplicacion_glifosato',
        'p4_terrenos_p4_aplicacion_glifosato_metros',
        //Cosecha P4
        'p4_cosecha_p4_aspecto_nivel1',
        'p4_cosecha_p4_aspecto_nivel2',
        'p4_cosecha_p4_aspecto_nivel3',
        'p4_cosecha_p4_n_plantas_n1',
        'p4_cosecha_p4_n_plantas_n2',
        'p4_cosecha_p4_n_plantas_n3',
        'p4_cosecha_p4_n_plantas_tot',
        'p4_cosecha_p4_edad_plantas',
        'p4_cosecha_p4_plantillas',
        'p4_cosecha_p4_plantillas_numero',
        'p4_cosecha_p4_kg_pergamino_n1',
        'p4_cosecha_p4_kg_pergamino_n2',
        'p4_cosecha_p4_kg_pergamino_n3',
        'p4_cosecha_p4_kg_pergamino_tot',
        // PARCELA 5
        'parcela_5_p5_cod_5',
        'parcela_5_p5_nombre',
        'parcela_5_p5_codigo',
        'parcela_5_p5_area_ant',
        'parcela_5_p5_activa',
        'parcela_5_p5_variacion_parcela',
        'parcela_5_p5_area_actual',
        'parcela_5_p5_variacion_explicacion',
        'parcela_5_p5_area_x',
        'parcela_5_p5_area',
        'parcela_5_p5_variedades',
        'parcela_5_p5_tipo_sombra',
        'parcela_5_p5_estado_sombra',
        'parcela_5_p5_arboles_altos',
        'parcela_5_p5_arboles_altos_numero',
        'parcela_5_p5_talas_inecesaria',
        'parcela_5_p5_renovacion_sombras',
        'parcela_5_p5_colindante_talas',
        'parcela_5_p5_materia_organica',
        'parcela_5_p5_cobertura',
        'parcela_5_p5_deslavado',
        'parcela_5_p5_practicas_conservacion',
        'parcela_5_p5_barreras_vivas',
        'parcela_5_p5_metros_barreras_vivas',
        'parcela_5_p5_terrazas',
        'parcela_5_p5_numero_terrazas',
        'parcela_5_p5_mantemimiento',
        'parcela_5_p5_mantenimiento_descripcion',
        'parcela_5_p5_aplica_estiercol_crudo',
        'parcela_5_p5_estiercol_crudo_plantas',
        'parcela_5_p5_estiercol_crudo_kg',
        'parcela_5_p5_podas',
        'parcela_5_p5_podas_descripcion',
        'parcela_5_p5_plagas_enfermedades',
        'parcela_5_p5_aplica_quimico',
        'parcela_5_p5_producto_quimico',
        'parcela_5_p5_fecha_producto_quimico',
        'parcela_5_p5_condiciones',
        'parcela_5_p5_basura',
        'parcela_5_p5_riesgo',
        'parcela_5_p5_observaciones',
        //Terrenos colindantes P5
        'p5_terrenos_p5_cod_5c',
        'p5_terrenos_p5_norte',
        'p5_terrenos_p5_norte_propietario',
        'p5_terrenos_p5_sur',
        'p5_terrenos_p5_sur_propietario',
        'p5_terrenos_p5_este',
        'p5_terrenos_p5_este_propietario',
        'p5_terrenos_p5_oeste',
        'p5_terrenos_p5_oeste_propietario',
        'p5_terrenos_p5_herbicidas_colindantes',
        'p5_terrenos_p5_nombre_herbicida_colindante',
        'p5_terrenos_p5_riesgos_contaminacion',
        'p5_terrenos_p5_lado_riesgos_contaminacion',
        'p5_terrenos_p5_franja_amortiguamiento',
        'p5_terrenos_p5_zanja',
        'p5_terrenos_p5_barreras_vivas_001',
        'p5_terrenos_p5_ninguna_evita_contaminacion',
        'p5_terrenos_p5_glifosato',
        'p5_terrenos_p5_aplicacion_glifosato',
        'p5_terrenos_p5_aplicacion_glifosato_metros',
        //Cosecha P5
        'p5_cosecha_p5_aspecto_nivel1',
        'p5_cosecha_p5_aspecto_nivel2',
        'p5_cosecha_p5_aspecto_nivel3',
        'p5_cosecha_p5_n_plantas_n1',
        'p5_cosecha_p5_n_plantas_n2',
        'p5_cosecha_p5_n_plantas_n3',
        'p5_cosecha_p5_n_plantas_tot',
        'p5_cosecha_p5_edad_plantas',
        'p5_cosecha_p5_plantillas',
        'p5_cosecha_p5_plantillas_numero',
        'p5_cosecha_p5_kg_pergamino_n1',
        'p5_cosecha_p5_kg_pergamino_n2',
        'p5_cosecha_p5_kg_pergamino_n3',
        'p5_cosecha_p5_kg_pergamino_tot',
        // PARCELA 6
        'parcela_6_p6_cod_6',
        'parcela_6_p6_nombre',
        'parcela_6_p6_codigo',
        'parcela_6_p6_area_ant',
        'parcela_6_p6_activa',
        'parcela_6_p6_variacion_parcela',
        'parcela_6_p6_area_actual',
        'parcela_6_p6_variacion_explicacion',
        'parcela_6_p6_area_x',
        'parcela_6_p6_area',
        'parcela_6_p6_variedades',
        'parcela_6_p6_tipo_sombra',
        'parcela_6_p6_estado_sombra',
        'parcela_6_p6_arboles_altos',
        'parcela_6_p6_arboles_altos_numero',
        'parcela_6_p6_talas_inecesaria',
        'parcela_6_p6_renovacion_sombras',
        'parcela_6_p6_colindante_talas',
        'parcela_6_p6_materia_organica',
        'parcela_6_p6_cobertura',
        'parcela_6_p6_deslavado',
        'parcela_6_p6_practicas_conservacion',
        'parcela_6_p6_barreras_vivas',
        'parcela_6_p6_metros_barreras_vivas',
        'parcela_6_p6_terrazas',
        'parcela_6_p6_numero_terrazas',
        'parcela_6_p6_mantemimiento',
        'parcela_6_p6_mantenimiento_descripcion',
        'parcela_6_p6_aplica_estiercol_crudo',
        'parcela_6_p6_estiercol_crudo_plantas',
        'parcela_6_p6_estiercol_crudo_kg',
        'parcela_6_p6_podas',
        'parcela_6_p6_podas_descripcion',
        'parcela_6_p6_plagas_enfermedades',
        'parcela_6_p6_aplica_quimico',
        'parcela_6_p6_producto_quimico',
        'parcela_6_p6_fecha_producto_quimico',
        'parcela_6_p6_condiciones',
        'parcela_6_p6_basura',
        'parcela_6_p6_riesgo',
        'parcela_6_p6_observaciones',
        //Terreno colindantes p6
        'p6_terrenos_p6_cod_6c',
        'p6_terrenos_p6_norte',
        'p6_terrenos_p6_norte_propietario',
        'p6_terrenos_p6_sur',
        'p6_terrenos_p6_sur_propietario',
        'p6_terrenos_p6_este',
        'p6_terrenos_p6_este_propietario',
        'p6_terrenos_p6_oeste',
        'p6_terrenos_p6_oeste_propietario',
        'p6_terrenos_p6_herbicidas_colindantes',
        'p6_terrenos_p6_nombre_herbicida_colindante',
        'p6_terrenos_p6_riesgos_contaminacion',
        'p6_terrenos_p6_lado_riesgos_contaminacion',
        'p6_terrenos_p6_franja_amortiguamiento',
        'p6_terrenos_p6_zanja',
        'p6_terrenos_p6_barreras_vivas_001',
        'p6_terrenos_p6_ninguna_evita_contaminacion',
        'p6_terrenos_p6_glifosato',
        'p6_terrenos_p6_aplicacion_glifosato',
        'p6_terrenos_p6_aplicacion_glifosato_metros',
        //Cosecha p6
        'p6_cosecha_p6_aspecto_nivel1',
        'p6_cosecha_p6_aspecto_nivel2',
        'p6_cosecha_p6_aspecto_nivel3',
        'p6_cosecha_p6_n_plantas_n1',
        'p6_cosecha_p6_n_plantas_n2',
        'p6_cosecha_p6_n_plantas_n3',
        'p6_cosecha_p6_n_plantas_tot',
        'p6_cosecha_p6_edad_plantas',
        'p6_cosecha_p6_plantillas',
        'p6_cosecha_p6_plantillas_numero',
        'p6_cosecha_p6_kg_pergamino_n1',
        'p6_cosecha_p6_kg_pergamino_n2',
        'p6_cosecha_p6_kg_pergamino_n3',
        'p6_cosecha_p6_kg_pergamino_tot',
        // PARCELA 7
        'parcela_7_p7_cod_7',
        'parcela_7_p7_nombre',
        'parcela_7_p7_codigo',
        'parcela_7_p7_area_ant',
        'parcela_7_p7_activa',
        'parcela_7_p7_variacion_parcela',
        'parcela_7_p7_area_actual',
        'parcela_7_p7_variacion_explicacion',
        'parcela_7_p7_area_x',
        'parcela_7_p7_area',
        'parcela_7_p7_variedades',
        'parcela_7_p7_tipo_sombra',
        'parcela_7_p7_estado_sombra',
        'parcela_7_p7_arboles_altos',
        'parcela_7_p7_arboles_altos_numero',
        'parcela_7_p7_talas_inecesaria',
        'parcela_7_p7_renovacion_sombras',
        'parcela_7_p7_colindante_talas',
        'parcela_7_p7_materia_organica',
        'parcela_7_p7_cobertura',
        'parcela_7_p7_deslavado',
        'parcela_7_p7_practicas_conservacion',
        'parcela_7_p7_barreras_vivas',
        'parcela_7_p7_metros_barreras_vivas',
        'parcela_7_p7_terrazas',
        'parcela_7_p7_numero_terrazas',
        'parcela_7_p7_mantemimiento',
        'parcela_7_p7_mantenimiento_descripcion',
        'parcela_7_p7_aplica_estiercol_crudo',
        'parcela_7_p7_estiercol_crudo_plantas',
        'parcela_7_p7_estiercol_crudo_kg',
        'parcela_7_p7_podas',
        'parcela_7_p7_podas_descripcion',
        'parcela_7_p7_plagas_enfermedades',
        'parcela_7_p7_aplica_quimico',
        'parcela_7_p7_producto_quimico',
        'parcela_7_p7_fecha_producto_quimico',
        'parcela_7_p7_condiciones',
        'parcela_7_p7_basura',
        'parcela_7_p7_riesgo',
        'parcela_7_p7_observaciones',
        //Terrenos colindantes P7
        'p7_terrenos_p7_cod_7c',
        'p7_terrenos_p7_norte',
        'p7_terrenos_p7_norte_propietario',
        'p7_terrenos_p7_sur',
        'p7_terrenos_p7_sur_propietario',
        'p7_terrenos_p7_este',
        'p7_terrenos_p7_este_propietario',
        'p7_terrenos_p7_oeste',
        'p7_terrenos_p7_oeste_propietario',
        'p7_terrenos_p7_herbicidas_colindantes',
        'p7_terrenos_p7_nombre_herbicida_colindante',
        'p7_terrenos_p7_riesgos_contaminacion',
        'p7_terrenos_p7_lado_riesgos_contaminacion',
        'p7_terrenos_p7_franja_amortiguamiento',
        'p7_terrenos_p7_zanja',
        'p7_terrenos_p7_barreras_vivas_001',
        'p7_terrenos_p7_ninguna_evita_contaminacion',
        'p7_terrenos_p7_glifosato',
        'p7_terrenos_p7_aplicacion_glifosato',
        'p7_terrenos_p7_aplicacion_glifosato_metros',
        //Cosecha P7
        'p7_cosecha_p7_aspecto_nivel1',
        'p7_cosecha_p7_aspecto_nivel2',
        'p7_cosecha_p7_aspecto_nivel3',
        'p7_cosecha_p7_n_plantas_n1',
        'p7_cosecha_p7_n_plantas_n2',
        'p7_cosecha_p7_n_plantas_n3',
        'p7_cosecha_p7_n_plantas_tot',
        'p7_cosecha_p7_edad_plantas',
        'p7_cosecha_p7_plantillas',
        'p7_cosecha_p7_plantillas_numero',
        'p7_cosecha_p7_kg_pergamino_n1',
        'p7_cosecha_p7_kg_pergamino_n2',
        'p7_cosecha_p7_kg_pergamino_n3',
        'p7_cosecha_p7_kg_pergamino_tot',
        // PARCELA 8
        'parcela_8_p8_cod_8',
        'parcela_8_p8_nombre',
        'parcela_8_p8_codigo',
        'parcela_8_p8_area_ant',
        'parcela_8_p8_activa',
        'parcela_8_p8_variacion_parcela',
        'parcela_8_p8_area_actual',
        'parcela_8_p8_variacion_explicacion',
        'parcela_8_p8_area_x',
        'parcela_8_p8_area',
        'parcela_8_p8_variedades',
        'parcela_8_p8_tipo_sombra',
        'parcela_8_p8_estado_sombra',
        'parcela_8_p8_arboles_altos',
        'parcela_8_p8_arboles_altos_numero',
        'parcela_8_p8_talas_inecesaria',
        'parcela_8_p8_renovacion_sombras',
        'parcela_8_p8_colindante_talas',
        'parcela_8_p8_materia_organica',
        'parcela_8_p8_cobertura',
        'parcela_8_p8_deslavado',
        'parcela_8_p8_practicas_conservacion',
        'parcela_8_p8_barreras_vivas',
        'parcela_8_p8_metros_barreras_vivas',
        'parcela_8_p8_terrazas',
        'parcela_8_p8_numero_terrazas',
        'parcela_8_p8_mantemimiento',
        'parcela_8_p8_mantenimiento_descripcion',
        'parcela_8_p8_aplica_estiercol_crudo',
        'parcela_8_p8_estiercol_crudo_plantas',
        'parcela_8_p8_estiercol_crudo_kg',
        'parcela_8_p8_podas',
        'parcela_8_p8_podas_descripcion',
        'parcela_8_p8_plagas_enfermedades',
        'parcela_8_p8_aplica_quimico',
        'parcela_8_p8_producto_quimico',
        'parcela_8_p8_fecha_producto_quimico',
        'parcela_8_p8_condiciones',
        'parcela_8_p8_basura',
        'parcela_8_p8_riesgo',
        'parcela_8_p8_observaciones',

        //Terrenos colindantes P8
        'p8_terrenos_p8_cod_8c',
        'p8_terrenos_p8_norte',
        'p8_terrenos_p8_norte_propietario',
        'p8_terrenos_p8_sur',
        'p8_terrenos_p8_sur_propietario',
        'p8_terrenos_p8_este',
        'p8_terrenos_p8_este_propietario',
        'p8_terrenos_p8_oeste',
        'p8_terrenos_p8_oeste_propietario',
        'p8_terrenos_p8_herbicidas_colindantes',
        'p8_terrenos_p8_nombre_herbicida_colindante',
        'p8_terrenos_p8_riesgos_contaminacion',
        'p8_terrenos_p8_lado_riesgos_contaminacion',
        'p8_terrenos_p8_franja_amortiguamiento',
        'p8_terrenos_p8_zanja',
        'p8_terrenos_p8_barreras_vivas_001',
        'p8_terrenos_p8_ninguna_evita_contaminacion',
        'p8_terrenos_p8_glifosato',
        'p8_terrenos_p8_aplicacion_glifosato',
        'p8_terrenos_p8_aplicacion_glifosato_metros',
        //Cosecha P8
        'p8_cosecha_p8_aspecto_nivel1',
        'p8_cosecha_p8_aspecto_nivel2',
        'p8_cosecha_p8_aspecto_nivel3',
        'p8_cosecha_p8_n_plantas_n1',
        'p8_cosecha_p8_n_plantas_n2',
        'p8_cosecha_p8_n_plantas_n3',
        'p8_cosecha_p8_n_plantas_tot',
        'p8_cosecha_p8_edad_plantas',
        'p8_cosecha_p8_plantillas',
        'p8_cosecha_p8_plantillas_numero',
        'p8_cosecha_p8_kg_pergamino_n1',
        'p8_cosecha_p8_kg_pergamino_n2',
        'p8_cosecha_p8_kg_pergamino_n3',
        'p8_cosecha_p8_kg_pergamino_tot',

        //Parcela P9
        'parcela_9_p9_cod_9',
        'parcela_9_p9_nombre',
        'parcela_9_p9_codigo',
        'parcela_9_p9_area_ant',
        'parcela_9_p9_activa',
        'parcela_9_p9_variacion_parcela',
        'parcela_9_p9_area_actual',
        'parcela_9_p9_variacion_explicacion',
        'parcela_9_p9_area_x',
        'parcela_9_p9_area',
        'parcela_9_p9_variedades',
        'parcela_9_p9_tipo_sombra',
        'parcela_9_p9_estado_sombra',
        'parcela_9_p9_arboles_altos',
        'parcela_9_p9_arboles_altos_numero',
        'parcela_9_p9_talas_inecesaria',
        'parcela_9_p9_renovacion_sombras',
        'parcela_9_p9_colindante_talas',
        'parcela_9_p9_materia_organica',
        'parcela_9_p9_cobertura',
        'parcela_9_p9_deslavado',
        'parcela_9_p9_practicas_conservacion',
        'parcela_9_p9_barreras_vivas',
        'parcela_9_p9_metros_barreras_vivas',
        'parcela_9_p9_terrazas',
        'parcela_9_p9_numero_terrazas',
        'parcela_9_p9_mantemimiento',
        'parcela_9_p9_mantenimiento_descripcion',
        'parcela_9_p9_aplica_estiercol_crudo',
        'parcela_9_p9_estiercol_crudo_plantas',
        'parcela_9_p9_estiercol_crudo_kg',
        'parcela_9_p9_podas',
        'parcela_9_p9_podas_descripcion',
        'parcela_9_p9_plagas_enfermedades',
        'parcela_9_p9_aplica_quimico',
        'parcela_9_p9_producto_quimico',
        'parcela_9_p9_fecha_producto_quimico',
        'parcela_9_p9_condiciones',
        'parcela_9_p9_basura',
        'parcela_9_p9_riesgo',
        'parcela_9_p9_observaciones',
        //Terrenos colindantes P9
        'p9_terrenos_p9_cod_9c',
        'p9_terrenos_p9_norte',
        'p9_terrenos_p9_norte_propietario',
        'p9_terrenos_p9_sur',
        'p9_terrenos_p9_sur_propietario',
        'p9_terrenos_p9_este',
        'p9_terrenos_p9_este_propietario',
        'p9_terrenos_p9_oeste',
        'p9_terrenos_p9_oeste_propietario',
        'p9_terrenos_p9_herbicidas_colindantes',
        'p9_terrenos_p9_nombre_herbicida_colindante',
        'p9_terrenos_p9_riesgos_contaminacion',
        'p9_terrenos_p9_lado_riesgos_contaminacion',
        'p9_terrenos_p9_franja_amortiguamiento',
        'p9_terrenos_p9_zanja',
        'p9_terrenos_p9_barreras_vivas_001',
        'p9_terrenos_p9_ninguna_evita_contaminacion',
        'p9_terrenos_p9_glifosato',
        'p9_terrenos_p9_aplicacion_glifosato',
        'p9_terrenos_p9_aplicacion_glifosato_metros',
        //Cosecha P9
        'p9_cosecha_p9_aspecto_nivel1',
        'p9_cosecha_p9_aspecto_nivel2',
        'p9_cosecha_p9_aspecto_nivel3',
        'p9_cosecha_p9_n_plantas_n1',
        'p9_cosecha_p9_n_plantas_n2',
        'p9_cosecha_p9_n_plantas_n3',
        'p9_cosecha_p9_n_plantas_tot',
        'p9_cosecha_p9_edad_plantas',
        'p9_cosecha_p9_plantillas',
        'p9_cosecha_p9_plantillas_numero',
        'p9_cosecha_p9_kg_pergamino_n1',
        'p9_cosecha_p9_kg_pergamino_n2',
        'p9_cosecha_p9_kg_pergamino_n3',
        'p9_cosecha_p9_kg_pergamino_tot',

        //Parcela adicional
        'parcela_ad_pad_cod_ad',
        'parcela_ad_pad_nombre_dis',
        'parcela_ad_numero_p_adicional',
        'parcela_ad_pad_cod',
        'parcela_ad_pad_area',
        'parcela_ad_pad_variedades',
        'parcela_ad_pad_tipo_sombra',
        'parcela_ad_pad_estado_sombra',
        'parcela_ad_pad_materia_organica',
        'parcela_ad_pad_cobertura',
        'parcela_ad_pad_deslavado',
        'parcela_ad_pad_practicas_conservacion',
        'parcela_ad_pad_barreras_vivas',
        'parcela_ad_pad_metros_barreras_vivas',
        'parcela_ad_pad_terrazas',
        'parcela_ad_pad_numero_terrazas',
        'parcela_ad_pad_mantemimiento',
        'parcela_ad_pad_mantenimiento_descripcion',
        'parcela_ad_pad_aplica_estiercol_crudo',
        'parcela_ad_pad_estiercol_crudo_plantas',
        'parcela_ad_pad_estiercol_crudo_kg',
        'parcela_ad_pad_podas',
        'parcela_ad_pad_podas_descripcion',
        'parcela_ad_pad_plagas_enfermedades',
        'parcela_ad_pad_aplica_quimico',
        'parcela_ad_pad_producto_quimico',
        'parcela_ad_pad_fecha_producto_quimico',
        'parcela_ad_pad_condiciones',
        'parcela_ad_pad_basura',
        'parcela_ad_pad_riesgo',
        'parcela_ad_pad_observaciones',
        //PD terrenos colindantes
        'pad_terrenos_pad_norte',
        'pad_terrenos_pad_norte_propietario',
        'pad_terrenos_pad_sur',
        'pad_terrenos_pad_sur_propietario',
        'pad_terrenos_pad_este',
        'pad_terrenos_pad_este_propietario',
        'pad_terrenos_pad_oeste',
        'pad_terrenos_pad_oeste_propietario',
        'pad_terrenos_pad_herbicidas_colindantes',
        'pad_terrenos_pad_nombre_herbicida_colindante',
        'pad_terrenos_pad_riesgos_contaminacion',
        'pad_terrenos_pad_lado_riesgos_contaminacion',
        'pad_terrenos_pad_franja_amortiguamiento',
        'pad_terrenos_pad_zanja',
        'pad_terrenos_pad_barreras_vivas_001',
        'pad_terrenos_pad_ninguna_evita_contaminacion',
        'pad_terrenos_pad_glifosato',
        'pad_terrenos_pad_aplicacion_glifosato',
        'pad_terrenos_pad_aplicacion_glifosato_metros',
        //Cosecha PAD
        'pad_cosecha_pad_aspecto_nivel1',
        'pad_cosecha_pad_aspecto_nivelad',
        'pad_cosecha_pad_aspecto_nivel3',
        'pad_cosecha_pad_n_plantas_n1',
        'pad_cosecha_pad_n_plantas_n2',
        'pad_cosecha_pad_n_plantas_n3',
        'pad_cosecha_pad_n_plantas_tot',
        'pad_cosecha_pad_edad_plantas',
        'pad_cosecha_pad_plantillas',
        'pad_cosecha_pad_plantillas_numero',
        'pad_cosecha_pad_kg_pergamino_n1',
        'pad_cosecha_pad_kg_pergamino_n2',
        'pad_cosecha_pad_kg_pergamino_n3',
        'pad_cosecha_pad_kg_pergamino_tot',

        // Resumen Parcelas
        'resumen_parcelas_parcelas_1_sum',
        'resumen_parcelas_parcelas_2_sum',
        'resumen_parcelas_parcelas_3_sum',
        'resumen_parcelas_parcelas_4_sum',
        'resumen_parcelas_parcelas_5_sum',
        'resumen_parcelas_parcelas_6_sum',
        'resumen_parcelas_parcelas_7_sum',
        'resumen_parcelas_parcelas_8_sum',
        'resumen_parcelas_parcelas_9_sum',
        'resumen_parcelas_parcelas_1',
        'resumen_parcelas_parcelas_2',
        'resumen_parcelas_parcelas_3',
        'resumen_parcelas_parcelas_4',
        'resumen_parcelas_parcelas_5',
        'resumen_parcelas_parcelas_6',
        'resumen_parcelas_parcelas_7',
        'resumen_parcelas_parcelas_8',
        'resumen_parcelas_parcelas_9',
        'resumen_parcelas_parcelas_totales',
        //Resumen areas parcelas
        'resumen_parcelas_area_p2_t',
        'resumen_parcelas_area_p3_t',
        'resumen_parcelas_area_p4_t',
        'resumen_parcelas_area_p5_t',
        'resumen_parcelas_area_p6_t',
        'resumen_parcelas_area_p7_t',
        'resumen_parcelas_area_p8_t',
        'resumen_parcelas_area_p9_t',
        'resumen_parcelas_area_pad_t',
        'resumen_parcelas_area_total',
        //Resumen plantas
        'resumen_parcelas_plantas_p1_n_plantas_x',
        'resumen_parcelas_plantas_p1_n_plantas_t',
        'resumen_parcelas_plantas_p2_n_plantas_x',
        'resumen_parcelas_plantas_p2_n_plantas_t',
        'resumen_parcelas_plantas_p3_n_plantas_x',
        'resumen_parcelas_plantas_p3_n_plantas_t',
        'resumen_parcelas_plantas_p4_n_plantas_x',
        'resumen_parcelas_plantas_p4_n_plantas_t',
        'resumen_parcelas_plantas_p5_n_plantas_x',
        'resumen_parcelas_plantas_p5_n_plantas_t',
        'resumen_parcelas_plantas_p6_n_plantas_x',
        'resumen_parcelas_plantas_p6_n_plantas_t',
        'resumen_parcelas_plantas_p7_n_plantas_x',
        'resumen_parcelas_plantas_p7_n_plantas_t',
        'resumen_parcelas_plantas_p8_n_plantas_x',
        'resumen_parcelas_plantas_p8_n_plantas_t',
        'resumen_parcelas_plantas_p9_n_plantas_x',
        'resumen_parcelas_plantas_p9_n_plantas_t',
        'resumen_parcelas_plantas_pad_n_plantas_t',
        'resumen_parcelas_plantas_totales',

        //Resumen parcelas - plantillas
        'resumen_parcelas_plantillas_p1_n_plantillas_s',
        'resumen_parcelas_plantillas_p1_n_plantillas_x',
        'resumen_parcelas_plantillas_p1_n_plantillas_t',
        'resumen_parcelas_plantillas_p2_n_plantillas_s',
        'resumen_parcelas_plantillas_p2_n_plantillas_x',
        'resumen_parcelas_plantillas_p2_n_plantillas_t',
        'resumen_parcelas_plantillas_p3_n_plantillas_s',
        'resumen_parcelas_plantillas_p3_n_plantillas_x',
        'resumen_parcelas_plantillas_p3_n_plantillas_t',
        'resumen_parcelas_plantillas_p4_n_plantillas_s',
        'resumen_parcelas_plantillas_p4_n_plantillas_x',
        'resumen_parcelas_plantillas_p4_n_plantillas_t',
        'resumen_parcelas_plantillas_p5_n_plantillas_s',
        'resumen_parcelas_plantillas_p5_n_plantillas_x',
        'resumen_parcelas_plantillas_p5_n_plantillas_t',
        'resumen_parcelas_plantillas_p6_n_plantillas_s',
        'resumen_parcelas_plantillas_p6_n_plantillas_x',
        'resumen_parcelas_plantillas_p6_n_plantillas_t',
        'resumen_parcelas_plantillas_p7_n_plantillas_s',
        'resumen_parcelas_plantillas_p7_n_plantillas_x',
        'resumen_parcelas_plantillas_p7_n_plantillas_t',
        'resumen_parcelas_plantillas_p8_n_plantillas_s',
        'resumen_parcelas_plantillas_p8_n_plantillas_x',
        'resumen_parcelas_plantillas_p8_n_plantillas_t',
        'resumen_parcelas_plantillas_p9_n_plantillas_s',
        'resumen_parcelas_plantillas_p9_n_plantillas_x',
        'resumen_parcelas_plantillas_p9_n_plantillas_t',
        'resumen_parcelas_plantillas_pad_n_plantillas_t',
        'resumen_parcelas_plantillas_totales',

        //Resumen parcelas - kilogramos
        'resumen_parcelas_kg_p1_x',
        'resumen_parcelas_kg_p1_t',
        'resumen_parcelas_kg_p2_x',
        'resumen_parcelas_kg_p2_t',
        'resumen_parcelas_kg_p3_x',
        'resumen_parcelas_kg_p3_t',
        'resumen_parcelas_kg_p4_x',
        'resumen_parcelas_kg_p4_t',
        'resumen_parcelas_kg_p5_x',
        'resumen_parcelas_kg_p5_t',
        'resumen_parcelas_kg_p6_x',
        'resumen_parcelas_kg_p6_t',
        'resumen_parcelas_kg_p7_x',
        'resumen_parcelas_kg_p7_t',
        'resumen_parcelas_kg_p8_x',
        'resumen_parcelas_kg_p8_t',
        'resumen_parcelas_kg_p9_x',
        'resumen_parcelas_kg_p9_t',
        'resumen_parcelas_kg_pad_t',
        'resumen_parcelas_kg_estimados_totales',
        'resumen_parcelas_kg_cosecha_pasada',

        //Observaciónes generales
        'resumen_parcelas_observaciones_generales',

        // Comprobación
        'comprobacion_razon_baja',
        'comprobacion_firma_insp',
        'comprobacion_firma_socio',
        'comprobacion_hora_final',

        // Metadatos
        'meta_instanceID',
        'meta_rootUuid',
        'meta_instanceName',
        'meta_deprecatedID',
        'formhub_uuid',
        '__version__',
        '_xform_id_string',
        '_uuid',
        //Campos adiciones del sistema
        '_attachments',
        '_status',
        '_geolocation',
        '_submission_time',
        '_tags',
        '_notes',
        '_validation_status',
        '_submitted_by',
        //Versionamiento por año
        'version',
    ];

    protected $casts = [
        'starttime' => 'datetime',
        'endtime' => 'datetime',
        'today' => 'date',
        'productor_fecha_nacimiento' => 'date',
        'productor_fecha_ingreso' => 'date',
        'productor_fecha_transicion' => 'date',
        'area_general_autoconsumo_fecha_quimicos' => 'date',
        'semillero_vivero_sem_fecha_aplicacion_quimico' => 'date',
        'semillero_vivero_sem_fecha_aplicacion_preparado' => 'date',
        'parcela_1_insumos_control_plagas_fecha' => 'date',
        'parcela_1_p1_fecha_producto_quimico' => 'date',
        'parcela_2_insumos_control_plagas_fecha' => 'date',
        'parcela_2_p2_fecha_producto_quimico' => 'date',
        'capacitaciones_cap_capacitacion_fecha' => 'date',
        '_attachments' => 'array',
        '_geolocation' => 'array',
        '_tags' => 'array',
        '_notes' => 'array',
        '_validation_status' => 'array',
        '_submission_time' => 'datetime',
        'area_general_area_autoconsumo' => 'decimal:2',
        'area_general_area_bosque' => 'decimal:2',
        'area_general_area_acahual' => 'decimal:2',
        'parcela_1_p1_metros_barreras_vivas' => 'decimal:2',
        'parcela_1_ceniza_kg' => 'decimal:2',
        'parcela_2_p2_metros_barreras_vivas' => 'decimal:2',
        'parcela_2_ceniza_kg' => 'decimal:2',
    ];

    // Accessors y Mutators opcionales

    /**
     * Get formatted producer name
     */
    public function getProducerFullNameAttribute()
    {
        return $this->p_nombre ?? 'N/A';
    }

    /**
     * Scope para filtrar por ciclo
     */
    public function scopeByCiclo($query, $ciclo)
    {
        return $query->where('ciclo_codigo', $ciclo);
    }

    /**
     * Scope para filtrar por inspector
     */
    public function scopeByInspector($query, $inspector)
    {
        return $query->where('info_general_inspector', $inspector);
    }

    /**
     * Scope para filtrar por DNI del productor
     */
    public function scopeByProducer($query, $dni)
    {
        return $query->where('productor_dni', $dni);
    }

    /**
     * Scope para filtrar por año
     */
    public function scopeByYear($query, $year)
    {
        return $query->where('version', $year);
    }
}
