<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Parcela extends Model
{
    use HasFactory;

    protected $table = 'parcelas';

    protected $fillable = [
        'internal_inspection_id',
        // Identificación de la parcela
        'numero_parcela',
        'codigo',
        'nombre',
        // Datos de área
        'area_ant',
        'activa',
        'variacion_parcela',
        'area_actual',
        'variacion_explicacion',
        'area_x',
        'area',
        // Características de cultivo
        'variedades',
        'tipo_sombra',
        'estado_sombra',
        'arboles_altos',
        'arboles_altos_numero',
        'talas_inecesaria',
        'renovacion_sombras',
        'colindante_talas',
        // Manejo del suelo
        'materia_organica',
        'cobertura',
        'deslavado',
        'practicas_conservacion',
        'barreras_vivas',
        'metros_barreras_vivas',
        'terrazas',
        'numero_terrazas',
        'mantemimiento',
        'mantenimiento_descripcion',
        // Fertilización
        'aplica_estiercol_crudo',
        'estiercol_crudo_plantas',
        'estiercol_crudo_kg',
        // Podas y plagas
        'podas',
        'podas_descripcion',
        'plagas_enfermedades',
        'aplica_quimico',
        'producto_quimico',
        'fecha_producto_quimico',
        // Condiciones generales
        'condiciones',
        'basura',
        'riesgo',
        'observaciones',
        // Campos específicos de parcela 1
        'control_plagas',
        'insumos_control_plagas',
        'insumos_plagas_seleccionados',
        'insumos_control_plagas_fecha',
        'insumos_insumos_aprobados',
        'aspersora',
        'basura_inorganica',
        'conservacion_agua',
        'conservacion_agua_actividades',
        'aplica_ceniza',
        'ceniza_plantas',
        'ceniza_kg',
        'ceniza_origen',
        'ceniza_tratada',
    ];

    protected $casts = [
        'area_ant' => 'decimal:2',
        'area_actual' => 'decimal:2',
        'area_x' => 'decimal:2',
        'area' => 'decimal:2',
        'arboles_altos_numero' => 'integer',
        'metros_barreras_vivas' => 'decimal:2',
        'numero_terrazas' => 'integer',
        'estiercol_crudo_plantas' => 'integer',
        'estiercol_crudo_kg' => 'decimal:2',
        'fecha_producto_quimico' => 'date',
        'insumos_control_plagas_fecha' => 'date',
        'ceniza_plantas' => 'integer',
        'ceniza_kg' => 'decimal:2',
    ];

    //Relación internal_inspection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
