<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Productor extends Model
{
    use HasFactory;

    protected $table = 'productores';

    protected $fillable = [
        'internal_inspection_id',
        'productor_dni',
        'productor_id_inspeccion',
        'productor_dni_o',
        'productor_socio',
        'productor_curp',
        'productor_rfc',
        'productor_ine',
        'productor_folio_cafetalero',
        'productor_folio_suri',
        'productor_municipio',
        'productor_localidad',
        'productor_grupo_trabajo',
        'productor_telefono',
        'productor_genero',
        'productor_fecha_nacimiento',
        'productor_fecha_ingreso',
        'productor_estatus',
        'productor_fecha_transicion',
        'productor_baja_productor',
        'productor_tenencia_tierra',
        'productor_titulo_tenencia',
        'productor_papel_tenencia',
        'productor_participa_otra_organizacion',
        'productor_producto_otra_organizazacion',
        'productor_nombre_otra_organizacion_001',
        'productor_familia_participa_otra_organizacion',
        'productor_familia_producto_otra_organizazacion',
        'productor_familia_otra_organizacion',
        'productor_familia_categoria_otra_organizacion',
    ];

    protected $casts = [
        'productor_fecha_nacimiento' => 'date',
        'productor_fecha_ingreso' => 'date',
        'productor_fecha_transicion' => 'date',
    ];

    // public function internalInspection()
    // {
    //     return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    // }
}
