<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResumenParcela extends Model
{
    use HasFactory;

    protected $table = 'resumenes_parcelas';

    protected $fillable = [
        'internal_inspection_id',
        // Totales de parcelas
        'parcelas_totales',
        'area_total',
        'plantas_totales',
        'plantillas_totales',
        'kg_estimados_totales',
        'kg_cosecha_pasada',
        'observaciones_generales',
    ];

    protected $casts = [
        'parcelas_totales' => 'integer',
        'area_total' => 'decimal:2',
        'plantas_totales' => 'integer',
        'plantillas_totales' => 'integer',
        'kg_estimados_totales' => 'decimal:2',
        'kg_cosecha_pasada' => 'decimal:2',
    ];

    //Relación con internal_inspection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
