<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SemilleroVivero extends Model
{
    use HasFactory;

    protected $table = 'semilleros_viveros';

    protected $fillable = [
        'internal_inspection_id',
        'semillero_vivero_sem_semillero',
        'semillero_vivero_sem_numero_semilleros',
        'semillero_vivero_sem_semillas_organicas',
        'semillero_vivero_sem_proveniencia_semillas',
        'semillero_vivero_variedades_semillas',
        'semillero_vivero_sem_control_plagas',
        'semillero_vivero_sem_aplica_producto_quimico',
        'semillero_vivero_sem_producto_quimico',
        'semillero_vivero_sem_fecha_aplicacion_quimico',
        'semillero_vivero_sem_aplica_preparado',
        'semillero_vivero_sem_preparado',
        'semillero_vivero_sem_fecha_aplicacion_preparado',
    ];

    protected $casts = [
        'semillero_vivero_sem_numero_semilleros' => 'integer',
        'semillero_vivero_sem_fecha_aplicacion_quimico' => 'date',
        'semillero_vivero_sem_fecha_aplicacion_preparado' => 'date',
    ];

    //Relación con internalInspection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
