<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Validation\Rules\Unique;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coffee_parcel_registries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('_id');

            // Información del formulario
            $table->dateTime('starttime')->nullable();
            $table->dateTime('endtime')->nullable();
            $table->date('today')->nullable();
            $table->string('deviceid')->nullable();
            $table->string('usuario')->nullable();
            $table->string('numero_telefono')->nullable(); 
            //numero_telefono

            // Información del socio
            $table->string('id_record')->nullable();
            $table->string('codigo_socio');
            $table->string('socio');

            // Información de la parcela
            $table->string('nombre_parcela');
            $table->string('n_parcela');
            $table->string('id_parcela');// id_parcela (codigo_socio + n_parcela)

            $table->string('ciclo');
            $table->decimal('superficie', 10, 2)->unsigned();//No puede almacenar negativos

            // Terrenos colindantes - Norte
            $table->string('norte')->nullable();
            $table->string('norte_propietario')->nullable();

            // Terrenos colindantes - Sur
            $table->string('sur')->nullable();
            $table->string('sur_propietario')->nullable();

            // Terrenos colindantes - Este
            $table->string('este')->nullable();
            $table->string('este_propietario')->nullable();

            // Terrenos colindantes - Oeste
            $table->string('oeste')->nullable();
            $table->string('oeste_propietario')->nullable();

            // Metadatos del formulario
            $table->string('meta_instanceID')->nullable();
            $table->string('meta_rootUuid')->nullable();
            $table->string('meta_instanceName')->nullable();
            $table->string('meta_deprecatedID')->nullable();

            $table->string('__version__')->nullable();
            $table->string('formhub_uuid')->nullable();
            $table->string('_xform_id_string')->nullable();
            $table->string('_uuid')->nullable();

            $table->string('_status')->nullable();
            $table->dateTime('_submission_time')->nullable();
            $table->string('_submitted_by')->nullable();
            $table->year('version')->default(date('Y'));

            $table->timestamps();
            
            // $table->foreign('codigo_socio')->references('id_productor')->on('producers')->cascadeOnDelete();

            $table->index(['_id', 'version']);
            $table->index('codigo_socio');

            
            $table->unique('id_parcela', 'version');

            // $table->unique(['codigo_socio','id_parcela'], 'unique_parcela_por_socio');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coffee_parcel_registries');
    }
};
