<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('georeferencings', function (Blueprint $table) {
            $table->bigIncrements('id');
            
            $table->bigInteger('_id')->nullable();
            $table->dateTime('start')->nullable();
            $table->dateTime('end')->nullable();
            $table->date('today')->nullable();

            $table->string('username')->nullable();
            $table->string('deviceid')->nullable();
            $table->string('phonenumber')->nullable();
            $table->string('hora')->nullable();
            $table->string('horas')->nullable();
            $table->string('minutos')->nullable();
            $table->string('segundos')->nullable();
            $table->string('anos')->nullable();
            $table->string('mes')->nullable();
            $table->string('dias')->nullable();

            $table->string('id_record')->nullable();
            $table->string('promotor')->nullable();
            $table->string('dni')->nullable();
            $table->string('socio')->nullable();
            $table->string('localidad')->nullable();
            $table->string('municipio')->nullable();
            $table->string('numero_parcela')->nullable();
            $table->string('codigo_parcela')->nullable(); // Quitar unique temporal
            $table->string('nombre_parcela')->nullable();
            $table->date('anio_incio_cultivo')->nullable();
            $table->string('gps')->nullable();
            $table->text('poligono')->nullable();
            $table->decimal('area_gps', 10, 2)->nullable();
            $table->decimal('area_gps_ha', 10, 2)->nullable();

            $table->string('area_gps_display')->nullable();
            $table->string('meta_instanceID')->nullable();
            $table->string('meta_rootUuid')->nullable();
            $table->string('meta_instanceName')->nullable();
            $table->string('meta_deprecatedID')->nullable(); // AGREGADO
            
            $table->dateTime('starttime')->nullable(); // CAMBIADO a dateTime
            $table->dateTime('endtime')->nullable(); // CAMBIADO a dateTime
            $table->string('p_nombre')->nullable();
            $table->string('ciclo_codigo')->nullable();
            $table->string('subscriberid')->nullable();
            $table->string('simid')->nullable();
            $table->string('formhub_uuid')->nullable();
            $table->string('__version__')->nullable();
            $table->string('_xform_id_string')->nullable();
            $table->string('_uuid')->nullable();
            $table->text('_attachments')->nullable(); // CAMBIADO a text
            $table->string('_status')->nullable();
            $table->text('_geolocation')->nullable();

            $table->dateTime('_submission_time')->nullable(); // CAMBIADO a dateTime
            $table->text('_tags')->nullable(); // CAMBIADO a text
            $table->text('_notes')->nullable(); // CAMBIADO a text
            $table->text('_validation_status')->nullable(); // CAMBIADO a text
            $table->string('_submitted_by')->nullable();

            $table->year('version')->default(date('Y'));
            
            $table->timestamps();

            $table->foreign('codigo_parcela')->references('id_parcela')->on('coffee_parcel_registries')->onDelete('cascade');

            $table->index(['_id', 'version']);
            $table->index(['codigo_parcela']);
            $table->index(['dni', 'numero_parcela']);
            
            // Unique constraint
            $table->unique(['codigo_parcela', 'version'], 'unique_georef_parcela_version');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('georeferencings');
    }
};