<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('human_rights_cases', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->bigInteger('_id')->unique(); 

            $table->string('formhub_uuid')->nullable();
            $table->dateTime('start')->nullable();
            $table->dateTime('end')->nullable();

            $table->string('nombre_encuestador')->nullable();
            $table->string('dni')->nullable();
            $table->string('dni_o')->nullable();
            $table->string('socio')->nullable();
            $table->string('municipio')->nullable();
            $table->string('localidad')->nullable();
            $table->string('grupo_trabajo')->nullable();
            $table->string('telefono')->nullable();
            $table->string('genero')->nullable();
            $table->date('fecha_nacimiento')->nullable();

            $table->string('contrato_mano_obra')->nullable();

            // select_multiple → JSON
            $table->json('edad_jornaleros')->nullable();
            $table->json('actividad_realizada')->nullable();

            $table->text('actividad_especifica')->nullable();
            $table->string('origen')->nullable();
            $table->string('estado')->nullable();
            $table->string('pais')->nullable();
            $table->string('comunidad')->nullable();
            $table->string('trabajo_forzado')->nullable();
            $table->text('observaciones')->nullable();

            $table->string('firma')->nullable();

            $table->string('__version__')->nullable();
            $table->string('instanceID')->nullable();
            $table->string('instanceName')->nullable();
            $table->string('_xform_id_string')->nullable();
            $table->string('_uuid')->nullable();
            $table->string('rootUuid')->nullable();
            $table->json('_attachments')->nullable();
            $table->string('_status')->nullable();
            $table->json('_geolocation')->nullable();
            $table->string('_submission_time')->nullable();
            $table->json('_tags')->nullable();
            $table->json('_notes')->nullable();
            $table->string('_validation_status')->nullable();
            $table->string('_submitted_by')->nullable();

            $table->year('version')->default(date('Y'));

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('human_rights_cases');
    }
};
