<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('beneficios_humedos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
            $table->string('beneficio_humedo_bh_fermentacion', 50)->nullable();
            $table->string('beneficio_humedo_bh_fuente_agua_lavado', 50)->nullable();
            $table->string('beneficio_humedo_bh_lavado_agua_potable', 10)->nullable();
            $table->string('beneficio_humedo_bh_destino_agua_miel', 50)->nullable();
            $table->string('beneficio_humedo_bh_despulpadora_tipo', 50)->nullable();
            $table->string('beneficio_bh_despulpadora_exclusiva', 10)->nullable();
            $table->string('beneficio_humedo_bh_destino_pulpa', 50)->nullable();
            $table->string('beneficio_humedo_bh_secado', 50)->nullable();
            $table->string('beneficio_humedo_bh_riesgo_contaminacion', 10)->nullable();
            $table->string('beneficio_humedo_bh_riesgo_contaminacion_area', 50)->nullable();
            $table->string('beneficio_humedo_bh_riesgos_mezcla_producto', 10)->nullable();
            $table->string('beneficio_humedo_bh_instalaciones_compartidas', 10)->nullable();
            $table->string('beneficio_humedo_bh_medidas_prevencion', 10)->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('beneficios_humedos');
    }
};
