<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('almacenamientos_insumos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
            $table->string('almacenamiento_insumos_bodega_especial', 10)->nullable();
            $table->string('almacenamiento_insumos_almacenamiento_exclusivo', 10)->nullable();
            $table->string('almacenamiento_insumos_prevencion_contaminacion_almacenamiento')->nullable();
            $table->string('almacenamiento_insumos_riesgos_mezcla_producto', 10)->nullable();
            $table->string('almacenamiento_insumos_prevencion_plagas_almacen', 50)->nullable();
            $table->string('almacenamiento_insumos_prevencion_plagas_almacen_describir', 50)->nullable();
            $table->string('almacenamiento_insumos_envases_exclusivos', 10)->nullable();
            $table->string('almacenamiento_insumos_riegos_costales', 10)->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('almacenamientos_insumos');
    }
};
