<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('capacitaciones', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
            $table->string('capacitaciones_cap_capacitaciones', 10)->nullable();
            $table->string('capacitaciones_cap_programa_individual', 10)->nullable();
            $table->string('capacitaciones_cap_registro_promotor', 10)->nullable();
            $table->string('capacitaciones_cap_capacitacion_recibida', 10)->nullable();
            $table->date('capacitaciones_cap_capacitacion_fecha')->nullable();
            $table->string('capacitaciones_cap_capacitacion_temas')->nullable();
            $table->string('capacitaciones_cap_practica_plan_manejo_organico')->nullable();
            $table->string('capacitaciones_cap_conoce_insumos_permitidos', 10)->nullable();
            $table->string('capacitaciones_cap_conoce_reglamento_interno', 10)->nullable();
            $table->string('capacitaciones_cap_recibos_ventas', 10)->nullable();
            $table->string('capacitaciones_conocimiento_premio_social', 10)->nullable();
            $table->string('capacitaciones_recibe_premio_social', 10)->nullable();
            $table->string('capacitaciones_uso_premio_social', 50)->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('capacitaciones');
    }
};
