<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parcelas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
            // Identificación de la parcela
            $table->string('numero_parcela', 20)->nullable(); // p1, p2, p3, etc.
            $table->string('codigo', 50)->nullable();
            $table->string('nombre', 200)->nullable();
            
            // Datos de área
            $table->decimal('area_ant', 10, 2)->nullable();
            $table->string('activa', 50)->nullable();
            $table->string('variacion_parcela', 50)->nullable();
            $table->decimal('area_actual', 10, 2)->nullable();
            $table->text('variacion_explicacion')->nullable();
            $table->decimal('area_x', 10, 2)->nullable();
            $table->decimal('area', 10, 2)->nullable();
            
            // Características de cultivo
            $table->text('variedades')->nullable();
            $table->text('tipo_sombra')->nullable();
            $table->string('estado_sombra', 50)->nullable();
            $table->string('arboles_altos', 50)->nullable();
            $table->integer('arboles_altos_numero')->nullable();
            $table->string('talas_inecesaria', 50)->nullable();
            $table->string('renovacion_sombras', 50)->nullable();
            $table->string('colindante_talas', 50)->nullable();
            
            // Manejo del suelo
            $table->string('materia_organica', 50)->nullable();
            $table->string('cobertura', 50)->nullable();
            $table->string('deslavado', 50)->nullable();
            $table->string('practicas_conservacion', 50)->nullable();
            $table->string('barreras_vivas', 50)->nullable();
            $table->decimal('metros_barreras_vivas', 10, 2)->nullable();
            $table->string('terrazas', 50)->nullable();
            $table->integer('numero_terrazas')->nullable();
            $table->string('mantemimiento', 50)->nullable();
            $table->text('mantenimiento_descripcion')->nullable();
            
            // Fertilización
            $table->string('aplica_estiercol_crudo', 50)->nullable();
            $table->integer('estiercol_crudo_plantas')->nullable();
            $table->decimal('estiercol_crudo_kg', 10, 2)->nullable();
            
            // Podas y plagas
            $table->string('podas', 50)->nullable();
            $table->text('podas_descripcion')->nullable();
            $table->text('plagas_enfermedades')->nullable();
            $table->string('aplica_quimico', 50)->nullable();
            $table->text('producto_quimico')->nullable();
            $table->date('fecha_producto_quimico')->nullable();
            
            // Condiciones generales
            $table->string('condiciones', 50)->nullable();
            $table->string('basura', 50)->nullable();
            $table->string('riesgo', 50)->nullable();
            $table->text('observaciones')->nullable();
            
            // Campos específicos de parcela 1
            $table->text('control_plagas')->nullable();
            $table->text('insumos_control_plagas')->nullable();
            $table->text('insumos_plagas_seleccionados')->nullable();
            $table->date('insumos_control_plagas_fecha')->nullable();
            $table->string('insumos_insumos_aprobados', 100)->nullable();
            $table->string('aspersora', 100)->nullable();
            $table->string('basura_inorganica', 100)->nullable();
            $table->string('conservacion_agua', 10)->nullable();
            $table->text('conservacion_agua_actividades')->nullable();
            $table->string('aplica_ceniza', 10)->nullable();
            $table->integer('ceniza_plantas')->nullable();
            $table->decimal('ceniza_kg', 10, 2)->nullable();
            $table->text('ceniza_origen')->nullable();
            $table->string('ceniza_tratada', 10)->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
                  
            $table->index(['internal_inspection_id', 'numero_parcela']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parcelas');
    }
};
