<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('terrenos_colindantes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('id_parcela'); // Cambiar a string para que coincida con coffee_parcel_registries
            
            // Colindancias
            $table->text('norte')->nullable();
            $table->string('norte_propietario', 200)->nullable();
            $table->text('sur')->nullable();
            $table->string('sur_propietario', 200)->nullable();
            $table->text('este')->nullable();
            $table->string('este_propietario', 200)->nullable();
            $table->text('oeste')->nullable();
            $table->string('oeste_propietario', 200)->nullable();
            
            // Riesgos y prevención
            $table->string('herbicidas_colindantes', 10)->nullable();
            $table->text('nombre_herbicida_colindante')->nullable();
            $table->string('riesgos_contaminacion', 10)->nullable();
            $table->text('lado_riesgos_contaminacion')->nullable();
            $table->string('franja_amortiguamiento', 10)->nullable();
            $table->string('zanja', 10)->nullable();
            $table->string('barreras_vivas_001', 10)->nullable();
            $table->text('ninguna_evita_contaminacion')->nullable();
            $table->string('glifosato', 50)->nullable();
            $table->string('aplicacion_glifosato', 10)->nullable();
            $table->integer('aplicacion_glifosato_metros')->nullable();
            
            $table->timestamps();
            
            $table->foreign('id_parcela')
                  ->references('id_parcela')
                  ->on('coffee_parcel_registries')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('terrenos_colindantes');
    }
};
