<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resumenes_parcelas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
            // Totales de parcelas
            $table->integer('parcelas_totales')->nullable();
            $table->decimal('area_total', 10, 2)->nullable();
            $table->integer('plantas_totales')->nullable();
            $table->integer('plantillas_totales')->nullable();
            $table->decimal('kg_estimados_totales', 10, 2)->nullable();
            $table->decimal('kg_cosecha_pasada', 10, 2)->nullable();
            
            $table->text('observaciones_generales')->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resumenes_parcelas');
    }
};
