
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    protected $connection = 'mongodb';

    public function up(): void
    {
        DB::connection('mongodb')->raw(function ($db) {
            $collection = $db->getCollection('inspecciones');

            $collection->createIndex(['dni' => 1]);
            $collection->createIndex(['fecha_visita' => -1]);
            
            // Índice único compuesto: id_inspeccion + version
            $collection->createIndex(
                ['id_inspeccion' => 1, 'version' => 1], 
                ['unique' => true]
            );
            
            $collection->createIndex(['inspector' => 1]);
            $collection->createIndex(['created_at' => -1]);
            $collection->createIndex(['version' => 1]);
        });
    }

    public function down(): void
    {
        // ✅ Forma correcta de eliminar la colección en MongoDB Laravel
        Schema::connection('mongodb')->dropIfExists('inspecciones');
        
        // O también puedes usar:
        // DB::connection('mongodb')->raw(function ($db) {
        //     $db->dropCollection('inspecciones');
        // });
    }
};


//use Illuminate\Database\Migrations\Migration;
// use Illuminate\Database\Schema\Blueprint;
// use Illuminate\Support\Facades\Schema;
// use Illuminate\Support\Facades\DB;

// return new class extends Migration
// {
//     protected $connection = 'mongodb';

//     public function up(): void
//     {
//         DB::connection('mongodb')->raw(function ($db) {
//             $collection = $db->getCollection('inspecciones');

//             $collection->createIndex(['dni' => 1]);
//             $collection->createIndex(['fecha_visita' => -1]);
//             $collection->createIndex(['id_inspeccion' => 1], ['unique' => true]);
//             $collection->createIndex(['inspector' => 1]);
//             $collection->createIndex(['created_at' => -1]);
//         });
//     }

//     public function down(): void
//     {
//         DB::connection('mongodb')->collection('inspecciones')->drop();
//     }
// };
