@extends('adminlte::page')

@section('title', 'Majomut - Inspección Interna')

@section('content_header')
    <h1><i class="fas fa-clipboard-check fa-2x opacity-75"></i> Inspección Interna - Vista Completa</h1>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" id="total-inspecciones">0</h3>
                                <p class="mb-0">Total Inspecciones</p>
                            </div>
                            <i class="fas fa-clipboard-check fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" id="total-productores">0</h3>
                                <p class="mb-0">Productores Únicos</p>
                            </div>
                            <i class="fas fa-users fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" id="total-parcelas">0</h3>
                                <p class="mb-0">Total Parcelas</p>
                            </div>
                            <i class="fas fa-map-marked-alt fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" id="total-hectareas">0</h3>
                                <p class="mb-0">Hectáreas Totales</p>
                            </div>
                            <i class="fas fa-chart-area fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-cloud-download-alt me-2"></i>
                    Importar desde KoBoToolbox
                </h5>
            </div>
            <div class="card-body">
                <form id="form-importar">
                    @csrf
                    <input type="hidden" name="asset_id" value="{{ config('services.kobotoolbox.INSPECCION_ASSET_UID') }}">
                    
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <label class="form-label">Año</label>
                            <input type="number" class="form-control" name="year" 
                                value="{{ date('Y') }}" min="2020" max="{{ date('Y') + 1 }}" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Usuario KoBo</label>
                            <input type="text" class="form-control" name="auth_credential" 
                                placeholder="Usuario" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Password</label>
                            <div class="input-group">
                                <input type="password" class="form-control" name="second_auth_credential" 
                                    placeholder="Password" required>
                                <button type="button" class="btn btn-outline-secondary" id="toggle-password">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Servidor</label>
                            <select class="form-select" name="server_url" required>
                                <option value="https://eu.kobotoolbox.org">Europa</option>
                                <option value="https://kf.kobotoolbox.org">Global</option>
                                <option value="https://kobo.humanitarianresponse.info">Humanitarian</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">&nbsp;</label>
                            <button type="button" class="btn btn-info w-100" id="btn-verificar">
                                <i class="fas fa-check-circle"></i> Verificar
                            </button>
                        </div>
                    </div>

                    <input type="hidden" name="auth_method" value="basic">

                    <!-- Info del Asset -->
                    <div id="asset-info" class="alert alert-info d-none mb-3">
                        <div id="asset-details"></div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-success btn-lg" id="btn-importar" disabled>
                                <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                                <i class="fas fa-download me-2"></i>
                                Importar Datos
                            </button>
                            <button type="button" class="btn btn-outline-primary btn-lg ms-2" id="btn-actualizar">
                                <i class="fas fa-sync-alt"></i> Actualizar Vista
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div> 

        
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-filter me-2"></i>Filtros</h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-2">
                        <label class="form-label">Año</label>
                        <select class="form-select" id="filtro-year">
                            <option value="">Todos</option>
                            <option value="2025">2025</option>
                            <option value="2024">2024</option>
                            <option value="2023">2023</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Inspector</label>
                        <select class="form-select" id="filtro-inspector">
                            <option value="">Todos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Municipio</label>
                        <select class="form-select" id="filtro-municipio">
                            <option value="">Todos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estatus</label>
                        <select class="form-select" id="filtro-estatus">
                            <option value="">Todos</option>
                            <option value="Organico">Orgánico</option>
                            <option value="Transicion">En Transición</option>
                            <option value="Convencional">Convencional</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estado Parcela</label>
                        <select class="form-select" id="filtro-activo">
                            <option value="">Todos</option>
                            <option value="Activa">Activas</option>
                            <option value="Inactiva">Inactivas</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <button class="btn btn-outline-secondary w-100" id="btn-limpiar-filtros">
                            <i class="fas fa-times"></i> Limpiar
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Listado Completo de Inspecciones</h3>
                <div class="card-tools">
                    <a href="{{ route('inspeccion.vista') }}" class="btn btn-info btn-sm mr-2" target="_blank">
                        <i class="fas fa-eye"></i> Vista Individual
                    </a>
                    <button class="btn btn-success btn-sm" id="btn-exportar-excel">
                        <i class="fas fa-file-excel"></i> Excel
                    </button>
                    <button class="btn btn-danger btn-sm" id="btn-exportar-pdf">
                        <i class="fas fa-file-pdf"></i> PDF
                    </button>
                    <button class="btn btn-primary btn-sm" id="reload">
                        <i class="fas fa-sync-alt"></i> Recargar
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="tabla-inspecciones" class="table table-bordered table-striped table-hover table-sm display nowrap" style="width:100%">
                        <thead>
                            <tr>
                                
                                <th>Kobo ID</th>
                                <th>Creado</th>
                                <th>Subido</th>
                                
                                
                                <th>Fecha Visita</th>
                                <th>Hora Inicio</th>
                                <th>Inspector</th>
                                <th>GPS</th>
                                <th>Nuevo?</th>
                                <th>Otra Org?</th>
                                <th>Nombre Org</th>
                                
                                
                                <th>DNI</th>
                                <th>ID Inspección</th>
                                <th>Socio</th>
                                <th>CURP</th>
                                <th>RFC</th>
                                <th>INE</th>
                                <th>Folio Cafetal</th>
                                <th>Folio SURI</th>
                                <th>Municipio</th>
                                <th>Localidad</th>
                                <th>Grupo Trabajo</th>
                                <th>Teléfono</th>
                                <th>Género</th>
                                <th>F. Nacimiento</th>
                                <th>F. Ingreso</th>
                                <th>Estatus</th>
                                <th>F. Transición</th>
                                <th>Baja?</th>
                                <th>Tenencia Tierra</th>
                                <th>Título?</th>
                                <th>Papel Tenencia</th>
                                <th>Otra Org Participa?</th>
                                <th>Producto Otra Org</th>
                                <th>Nombre Otra Org 001</th>
                                <th>Familia Otra Org?</th>
                                <th>Familia Producto</th>
                                <th>Familia Org</th>
                                <th>Familia Categoría</th>
                                
                                
                                <th>Autoconsumo?</th>
                                <th>Área Autoconsumo</th>
                                <th>N° Parc Autocons</th>
                                <th>Químicos Autocons</th>
                                <th>F. Químicos</th>
                                <th>Potrero?</th>
                                <th>Área Potrero</th>
                                <th>N° Parc Potrero</th>
                                <th>Bosque?</th>
                                <th>Área Bosque</th>
                                <th>N° Parc Bosque</th>
                                <th>Acahual?</th>
                                <th>Área Acahual</th>
                                <th>N° Parc Acahual</th>
                                
                                
                                <th>Semillero?</th>
                                <th>N° Semillas</th>
                                <th>Semillas Org?</th>
                                <th>Proveniencia</th>
                                <th>Variedades Sem</th>
                                <th>Control Plagas</th>
                                <th>Aplica Químico?</th>
                                <th>Producto Químico</th>
                                <th>F. Aplic Quím</th>
                                <th>Aplica Prep?</th>
                                <th>Preparado</th>
                                <th>F. Aplic Prep</th>
                                
                                
                                <th>Abono Org?</th>
                                <th>Tipo Abono</th>
                                <th>Plantas Abono</th>
                                <th>Kg Composta</th>
                                <th>Kg/Planta</th>
                                <th>Litros Lixiv</th>
                                <th>Plantas Foliar</th>
                                <th>Donde Aplicó</th>
                                <th>Composta Vivero?</th>
                                <th>Bolsas Vivero</th>
                                <th>Compra Abono?</th>
                                <th>Cumple Normas?</th>
                                <th>Kg Cosecha Abono</th>
                                <th>Plantas Abonadas</th>
                                <th>Estiércol Crudo?</th>
                                <th>Plantas Est Crudo</th>
                                <th>Kg Est Crudo</th>
                                
                                
                                <th>Fermentación</th>
                                <th>Fuente Agua</th>
                                <th>Agua Potable?</th>
                                <th>Destino Agua Miel</th>
                                <th>Despulpadora</th>
                                <th>Desp Exclusiva?</th>
                                <th>Destino Pulpa</th>
                                <th>Secado</th>
                                <th>Riesgo Contam?</th>
                                <th>Área Riesgo</th>
                                <th>Riesgo Mezcla?</th>
                                <th>Inst Compartidas?</th>
                                <th>Medidas Prev?</th>
                                
                                
                                <th>Bodega Esp?</th>
                                <th>Almac Exclusivo?</th>
                                <th>Prev Contam</th>
                                <th>Riesgo Mezcla Alm</th>
                                <th>Prev Plagas</th>
                                <th>Describir Prev</th>
                                <th>Envases Excl?</th>
                                <th>Riesgo Costales?</th>
                                
                                
                                <th>Capacitaciones?</th>
                                <th>Programa Ind?</th>
                                <th>Registro Prom?</th>
                                <th>Cap Recibida?</th>
                                <th>F. Capacitación</th>
                                <th>Temas Capac</th>
                                <th>Practica Plan?</th>
                                <th>Conoce Insumos?</th>
                                <th>Conoce Reglam?</th>
                                <th>Recibos Ventas?</th>
                                <th>Conoce Premio?</th>
                                <th>Recibe Premio?</th>
                                <th>Uso Premio</th>
                                
                               
                                <th>Num Parcela</th>
                                <th>Código Parcela</th>
                                <th>Nombre Parcela</th>
                                <th>Superficie</th>
                                <th>Estado Parcela</th>
                                <th>Variación?</th>
                                <th>Área Actual</th>
                                <th>Explicación Var</th>
                                <th>Variedades</th>
                                <th>Tipo Sombra</th>
                                <th>Estado Sombra</th>
                                <th>Árboles Altos?</th>
                                <th>N° Árb Altos</th>
                                <th>Talas Innec?</th>
                                <th>Renov Sombras?</th>
                                <th>Colindan Talas?</th>
                                <th>Materia Orgánica</th>
                                <th>Cobertura</th>
                                <th>Deslavado?</th>
                                <th>Prác Conserv?</th>
                                <th>Barreras Vivas?</th>
                                <th>Metros Barreras</th>
                                <th>Terrazas?</th>
                                <th>N° Terrazas</th>
                                <th>Mantenimiento?</th>
                                <th>Desc Manten</th>
                                <th>Est Crudo?</th>
                                <th>Plantas Est C</th>
                                <th>Kg Est C</th>
                                <th>Podas?</th>
                                <th>Desc Podas</th>
                                <th>Plagas/Enferm</th>
                                <th>Aplica Quím?</th>
                                <th>Prod Químico</th>
                                <th>F. Prod Quím</th>
                                <th>Condiciones</th>
                                <th>Basura?</th>
                                <th>Riesgo</th>
                                <th>Observaciones</th>
                                <th>Norte</th>
                                <th>Norte Propiet</th>
                                <th>Sur</th>
                                <th>Sur Propiet</th>
                                <th>Este</th>
                                <th>Este Propiet</th>
                                <th>Oeste</th>
                                <th>Oeste Propiet</th>
                                <th>Herbicidas Col?</th>
                                <th>Nombre Herbic</th>
                                <th>Riesgo Contam?</th>
                                <th>Lado Riesgo</th>
                                <th>Franja Amort?</th>
                                <th>Zanja?</th>
                                <th>Barreras Prot?</th>
                                <th>Ninguna</th>
                                <th>Glifosato?</th>
                                <th>Aplic Glifos?</th>
                                <th>Metros Glifos</th>
                                <th>Aspecto N1</th>
                                <th>Aspecto N2</th>
                                <th>Aspecto N3</th>
                                <th>Plantas N1</th>
                                <th>Plantas N2</th>
                                <th>Plantas N3</th>
                                <th>Plantas Tot</th>
                                <th>Edad Plantas</th>
                                <th>Plantillas?</th>
                                <th>N° Plantillas</th>
                                <th>Kg Perg N1</th>
                                <th>Kg Perg N2</th>
                                <th>Kg Perg N3</th>
                                <th>Kg Perg Tot</th>
                                <th>Cond Product</th>
                                
                                
                                <th>Parcelas Tot</th>
                                <th>Área Total</th>
                                <th>Plantas Tot</th>
                                <th>Plantillas Tot</th>
                                <th>Kg Est Tot</th>
                                <th>Kg Cosecha Pas</th>
                                <th>Obs Generales</th>
                                
                                
                                <th>Razón Baja</th>
                                <th>Hora Final</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/fixedcolumns/4.3.0/css/fixedColumns.bootstrap5.min.css">

    <style>
        .card {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .table th {
            background-color: #f8f9fa;
            font-weight: 600;
            font-size: 0.75rem;
            white-space: nowrap;
            padding: 8px 4px;
        }
        .table td {
            font-size: 0.75rem;
            padding: 6px 4px;
            white-space: nowrap;
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            max-width: 400px;
        }
        
        
        .estado-activa {
            background-color: #28a745;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 0.7rem;
        }
        .estado-inactiva {
            background-color: #dc3545;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 0.7rem;
        }
        
        
        table.dataTable thead th:nth-child(1),
        table.dataTable thead th:nth-child(2),
        table.dataTable thead th:nth-child(3) {
            position: sticky;
            left: 0;
            z-index: 10;
            background-color: #f8f9fa;
        }
    </style>
@stop

@section('js')
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/fixedcolumns/4.3.0/js/dataTables.fixedColumns.min.js"></script>

    <script>
        $(document).ready(function() {
            let tabla;
            let datosOriginales = [];

            
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            
            function initDataTable() {
                tabla = $('#tabla-inspecciones').DataTable({
                    scrollX: true,
                    scrollCollapse: true,
                    processing: true,
                    serverSide: false,
                    ajax: {
                        url: '/Inspeccio/datos',
                        dataSrc: function(json) {
                            datosOriginales = json.data;
                            actualizarEstadisticas(json.data);
                            cargarOpcionesFiltros(json.data);
                            return json.data;
                        }
                    },
                    columnDefs: [
                        {
                            
                            targets: 119,
                            render: function(data, type, row) {
                                if (data === 'Activa') {
                                    return '<span class="estado-activa">ACTIVA</span>';
                                } else if (data === 'Inactiva') {
                                    return '<span class="estado-inactiva">INACTIVA</span>';
                                }
                                return data;
                            }
                        },
                        {
                            
                            targets: [1, 2, 3, 23, 24, 26, 42, 60, 63, 106, 149],
                            render: function(data, type, row) {
                                if (!data || data === '') return '';
                                if (type === 'display' || type === 'filter') {
                                    const fecha = new Date(data);
                                    if (!isNaN(fecha)) {
                                        return fecha.toLocaleDateString('es-ES');
                                    }
                                }
                                return data;
                            }
                        },
                        {
                            
                            targets: [39, 44, 47, 50, 67, 68, 69, 76, 80, 118, 121, 136, 143, 183, 184, 185, 186, 189, 190, 191, 192],
                            render: function(data, type, row) {
                                if (!data || data === '') return '0';
                                if (type === 'display') {
                                    return parseFloat(data).toFixed(2);
                                }
                                return data;
                            }
                        }
                    ],
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.13.4/i18n/es-ES.json'
                    },
                    dom: 'Bfrtip',
                    buttons: [
                        {
                            extend: 'copy',
                            text: '<i class="fas fa-copy"></i> Copiar',
                            className: 'btn btn-secondary btn-sm'
                        },
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            className: 'btn btn-success btn-sm'
                        },
                        {
                            extend: 'excel',
                            text: '<i class="fas fa-file-excel"></i> Excel',
                            className: 'btn btn-success btn-sm',
                            title: 'Inspecciones_Completo_' + new Date().toISOString().split('T')[0]
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Imprimir',
                            className: 'btn btn-primary btn-sm'
                        }
                    ],
                    pageLength: 25,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
                    order: [[3, 'desc']], 
                    fixedColumns: {
                        leftColumns: 3
                    },
                    initComplete: function() {
                        console.log('DataTable inicializado con todas las columnas');
                    }
                });
            }

            function actualizarEstadisticas(datos) {
                const totalInspecciones = datos.length;
                const productoresUnicos = new Set(datos.map(d => d[10])).size; 
                const totalParcelas = datos.filter(d => d[117]).length; 
                const totalHectareas = datos.reduce((sum, d) => sum + (parseFloat(d[118]) || 0), 0); 

                $('#total-inspecciones').text(totalInspecciones);
                $('#total-productores').text(productoresUnicos);
                $('#total-parcelas').text(totalParcelas);
                $('#total-hectareas').text(totalHectareas.toFixed(2));
            }

            
            function cargarOpcionesFiltros(datos) {
                
                const inspectores = [...new Set(datos.map(d => d[5]).filter(Boolean))].sort();
                const $filtroInspector = $('#filtro-inspector');
                $filtroInspector.empty().append('<option value="">Todos</option>');
                inspectores.forEach(inspector => {
                    $filtroInspector.append(`<option value="${inspector}">${inspector}</option>`);
                });

                
                const municipios = [...new Set(datos.map(d => d[18]).filter(Boolean))].sort();
                const $filtroMunicipio = $('#filtro-municipio');
                $filtroMunicipio.empty().append('<option value="">Todos</option>');
                municipios.forEach(municipio => {
                    $filtroMunicipio.append(`<option value="${municipio}">${municipio}</option>`);
                });
            }

            
            $('#toggle-password').on('click', function() {
                const input = $('input[name="second_auth_credential"]');
                const icon = $(this).find('i');
                
                if (input.attr('type') === 'password') {
                    input.attr('type', 'text');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                } else {
                    input.attr('type', 'password');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                }
            });

            
            $('#btn-verificar').on('click', function() {
                const formData = {
                    auth_method: 'basic',
                    auth_credential: $('input[name="auth_credential"]').val(),
                    second_auth_credential: $('input[name="second_auth_credential"]').val(),
                    asset_id: $('input[name="asset_id"]').val(),
                    server_url: $('select[name="server_url"]').val(),
                    year: $('input[name="year"]').val()
                };

                if (!formData.auth_credential || !formData.second_auth_credential) {
                    showNotification('Por favor completa todos los campos requeridos', 'error');
                    return;
                }

                const btn = $(this);
                btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Verificando...');

                $.post('/Inspeccio/info-asset', formData)
                    .done(function(response) {
                        if (response.success) {
                            $('#asset-info').removeClass('d-none');
                            $('#asset-details').html(`
                                <strong>Asset:</strong> ${response.name}<br>
                                <strong>Registros:</strong> ${response.deployment_count}<br>
                                <strong>Modificado:</strong> ${response.date_modified ? new Date(response.date_modified).toLocaleString('es-ES') : 'N/A'}
                            `);
                            $('#btn-importar').prop('disabled', false);
                            showNotification('Credenciales verificadas correctamente', 'success');
                        } else {
                            $('#asset-info').addClass('d-none');
                            showNotification('Error: ' + response.message, 'error');
                        }
                    })
                    .fail(function(xhr) {
                        $('#asset-info').addClass('d-none');
                        const message = xhr.responseJSON?.message || 'Error desconocido';
                        showNotification('Error al verificar: ' + message, 'error');
                    })
                    .always(function() {
                        btn.prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verificar');
                    });
            });

            
            $('#form-importar').on('submit', function(e) {
                e.preventDefault();
                
                const formData = {
                    year: $('input[name="year"]').val(),
                    auth_method: 'basic',
                    auth_credential: $('input[name="auth_credential"]').val(),
                    second_auth_credential: $('input[name="second_auth_credential"]').val(),
                    asset_id: $('input[name="asset_id"]').val(),
                    server_url: $('select[name="server_url"]').val()
                };

                const btn = $('#btn-importar');
                const spinner = btn.find('.spinner-border');
                
                btn.prop('disabled', true);
                spinner.removeClass('d-none');
                btn.find('i.fa-download').addClass('d-none');
                
                $.post('/Inspeccio/importar-kobo', formData)
                    .done(function(response) {
                        if (response.success) {
                            let mensaje = `Importación exitosa:<br>
                                - Total procesados: ${response.total}<br>
                                - Importados: ${response.imported}<br>
                                - Actualizados: ${response.updated || 0}`;
                            
                            if (response.errors > 0) {
                                mensaje += `<br>- Errores: ${response.errors}`;
                            }
                            
                            showNotification(mensaje, 'success');
                            
                            setTimeout(() => {
                                if (tabla) {
                                    tabla.ajax.reload();
                                }
                            }, 2000);
                        } else {
                            showNotification('Error: ' + response.message, 'error');
                        }
                    })
                    .fail(function(xhr) {
                        const message = xhr.responseJSON?.message || 'Error desconocido';
                        showNotification('Error en la importación: ' + message, 'error');
                    })
                    .always(function() {
                        btn.prop('disabled', false);
                        spinner.addClass('d-none');
                        btn.find('i.fa-download').removeClass('d-none');
                    });
            });

            
            $('#filtro-year, #filtro-inspector, #filtro-municipio, #filtro-estatus, #filtro-activo').on('change', function() {
                aplicarFiltros();
            });

            function aplicarFiltros() {
                if (!tabla) return;

                const year = $('#filtro-year').val();
                const inspector = $('#filtro-inspector').val();
                const municipio = $('#filtro-municipio').val();
                const estatus = $('#filtro-estatus').val();
                const activo = $('#filtro-activo').val();

                tabla.column(3).search(year); 
                tabla.column(5).search(inspector); 
                tabla.column(18).search(municipio); 
                tabla.column(25).search(estatus); 
                tabla.column(119).search(activo); 
                
                tabla.draw();
            }

            
            $('#btn-limpiar-filtros').on('click', function() {
                $('#filtro-year, #filtro-inspector, #filtro-municipio, #filtro-estatus, #filtro-activo').val('');
                if (tabla) {
                    tabla.columns().search('').draw();
                }
            });

            
            $('#reload, #btn-actualizar').on('click', function() {
                if (tabla) {
                    tabla.ajax.reload();
                    showNotification('Datos actualizados', 'success');
                }
            });

            
            function showNotification(message, type) {
                const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
                const icon = type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-triangle';
                
                const notification = $(`
                    <div class="alert ${alertClass} alert-dismissible fade show notification">
                        <i class="${icon} me-2"></i>
                        ${message}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                `);
                
                $('body').append(notification);
                setTimeout(() => notification.alert('close'), 5000);
            }

            
            initDataTable();
        });
    </script>
@stop