<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Portal SIC - Login</title>

        <!-- Favicon -->
        <link href="{{ asset('img/favicon.ico') }}" rel="icon">

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        <link rel="preconnect" href="https://fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@200;400&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

        <!-- Font Awesome -->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

        <!-- Bootstrap 4 CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

        <!-- Custom CSS -->
        <style>
            .login-card {
                background-color: rgba(255, 255, 255, 0.85); /* Fondo blanco semitransparente */
                backdrop-filter: blur(5px); /* Efecto de desenfoque */
                border: 1px solid rgba(255, 255, 255, 0.2);
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            }
            
            .login-container {
                height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .full-screen-bg {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                z-index: -1;
                background: url('{{ asset("img/carousel-1.jpg") }}') no-repeat center center;
                background-size: cover;
                filter: brightness(0.7);
            }
        </style>

        @vite('resources/css/app.css')
    </head>
    <body class="text-[#1b1b18]">
        <header class="w-full text-sm fixed-top" style="z-index: 1030;">
            <nav class="fixed-top"> <!-- Fija la barra en la parte superior -->
                <div class="container-fluid">
                    <a href="{{ route('home') }}" class="navbar-brand p-0 m-0"> <!-- Eliminamos padding y margin -->
                        <img src="{{ asset('vendor/adminlte/dist/img/image.png') }}" 
                            alt="Logo" 
                            style="height: 40px; width: auto; margin-left: 15px; margin-top: 5px;"> <!-- Tamaño y margen personalizado -->
                    </a>
                </div>
            </nav>
            @if (Route::has('dashboard'))
                <nav class="flex items-center justify-end gap-4 p-4">
                    @auth
                        <a
                            href="{{ url('/dashboard') }}"
                            class="inline-block px-5 py-1.5 dark:text-[#EDEDEC] border-[#19140035] hover:border-[#1915014a] border text-[#1b1b18] dark:border-[#3E3E3A] dark:hover:border-[#62605b] rounded-sm text-sm leading-normal"
                        >
                            Dashboard
                        </a>
                    @else
                        <a
                            href="{{ route('login') }}"
                            class="inline-block px-5 py-1.5 dark:text-[#EDEDEC] text-[#1b1b18] border border-transparent hover:border-[#19140035] dark:hover:border-[#3E3E3A] rounded-sm text-sm leading-normal"
                        >
                            Log in
                        </a>

                        @if (Route::has('register'))
                            <a
                                href="{{ route('register') }}"
                                class="inline-block px-5 py-1.5 dark:text-[#EDEDEC] border-[#19140035] hover:border-[#1915014a] border text-[#1b1b18] dark:border-[#3E3E3A] dark:hover:border-[#62605b] rounded-sm text-sm leading-normal">
                                Register
                            </a>
                        @endif
                        
                    @endauth
                </nav>
            @endif
        </header>
        <!-- Fondo de pantalla completa -->
        <div class="full-screen-bg"></div>
        
        <!-- Contenedor principal -->
        <div class="login-container">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-5">
                        <!-- Tarjeta de login transparente -->
                        <div class="login-card rounded-sm p-4 p-md-5">
                            <!-- Logo/Marca -->
                            <div class="text-center mb-4">
                                <h2 class="font-weight-bold">PORTAL SIC</h2>
                                <p class="text-muted">Sistema Integral de Control</p>
                            </div>
                            
                            <!-- Session Status -->
                            <x-auth-session-status class="mb-4" :status="session('status')" />

                            <form method="POST" action="{{ route('login') }}">
                                @csrf

                                <!-- Email Address -->
                                <div class="mb-3">
                                    <x-input-label class="text-custom-brown" for="email" :value="__('Email')" />
                                    <x-text-input id="email" class="form-control rounded-sm" 
                                                 type="email" name="email" 
                                                 :value="old('email')" required autofocus 
                                                 autocomplete="username" />
                                    <x-input-error :messages="$errors->get('email')" class="mt-2 text-danger" />
                                </div>

                                <!-- Password -->
                                <div class="mb-3">
                                    <x-input-label class="text-custom-brown" for="password" :value="__('Password')" />
                                    <x-text-input id="password" class="form-control rounded-sm"
                                                 type="password"
                                                 name="password"
                                                 required autocomplete="current-password" />
                                    <x-input-error :messages="$errors->get('password')" class="mt-2 text-danger" />
                                </div>

                                <!-- Remember Me -->
                                <div class="mb-3 form-check">
                                    <input id="remember_me" type="checkbox" class="form-check-input" name="remember">
                                    <label for="Recordar mi sesion" class="form-check-label">{{ __('Recordar mi sesion') }}</label>
                                </div>

                                <div class="d-flex justify-content-between align-items-center">
                                    @if (Route::has('password.request'))
                                        <a class="text-sm text-muted" href="{{ route('login') }}">
                                            {{-- ex --}}
                                            {{ __('Recuperar contraseña?') }}
                                        </a>
                                    @endif

                                    <x-primary-button class="px-4 py-2" class="text-push-register">
                                        {{ __('Log in') }}
                                    </x-primary-button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- JavaScript Libraries -->
        <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

        @vite('resources/js/app.js')
    </body>
</html>