<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Portal SIC - Registro</title>

        <!-- Favicon -->
        <link href="{{ asset('img/favicon.ico') }}" rel="icon">

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        <link rel="preconnect" href="https://fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@200;400&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

        <!-- Font Awesome -->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

        <!-- Bootstrap 4 CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

        <!-- Custom CSS -->
        <style>
            .register-card {
                background-color: rgba(255, 255, 255, 0.85);
                backdrop-filter: blur(5px);
                border: 1px solid rgba(255, 255, 255, 0.2);
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
                border-radius: 8px;
            }
            
            .register-container {
                height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            
            .full-screen-bg {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                z-index: -1;
                background: url('{{ asset("img/carousel-2.jpg") }}') no-repeat center center;
                background-size: cover;
                filter: brightness(0.7);
            }
            
            .form-control-custom {
                border-radius: 6px;
                border: 1px solid #ced4da;
                padding: 10px 15px;
                transition: all 0.3s;
            }
            
            .form-control-custom:focus {
                border-color: #86b7fe;
                box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
            }
        </style>

        @vite('resources/css/app.css')
    </head>
    <body class="text-[#1b1b18]">
        <!-- Fondo de pantalla completa -->
        <div class="full-screen-bg"></div>
        
        <!-- Contenedor principal -->
        <div class="register-container">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6">
                        <!-- Tarjeta de registro transparente -->
                        <div class="register-card p-4 p-md-5">
                            <!-- Logo/Marca -->
                            <div class="text-center mb-4">
                                <h2 class="font-weight-bold">CREAR CUENTA</h2>
                                <p class="text-muted">Portal SIC Majomut</p>
                            </div>
                            
                            <!-- Errores de validación -->
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul class="mb-0">
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <form method="POST" action="{{ route('register') }}">
                                @csrf

                                <!-- Nombre -->
                                <div class="mb-3">
                                    <x-input-label class="text-custom-brown" for="name" :value="__('Name')" />
                                    <x-text-input id="name" class="form-control-custom w-full" 
                                                 type="text" name="name" 
                                                 :value="old('name')" required 
                                                 autofocus autocomplete="name" />
                                    <x-input-error :messages="$errors->get('name')" class="mt-2 text-danger" />
                                </div>

                                <!-- Email -->
                                <div class="mb-3">
                                    <x-input-label class="text-custom-brown" for="email" :value="__('Email')" />
                                    <x-text-input id="email" class="form-control-custom w-full" 
                                                 type="email" name="email" 
                                                 :value="old('email')" required 
                                                 autocomplete="username" />
                                    <x-input-error :messages="$errors->get('email')" class="mt-2 text-danger" />
                                </div>

                                <!-- Contraseña -->
                                <div class="mb-3">
                                    <x-input-label class="text-custom-brown" for="password" :value="__('Password')" />
                                    <x-text-input id="password" class="form-control-custom w-full"
                                                 type="password"
                                                 name="password"
                                                 required autocomplete="new-password" />
                                    <x-input-error :messages="$errors->get('password')" class="mt-2 text-danger" />
                                </div>

                                <!-- Confirmar Contraseña -->
                                <div class="mb-4">
                                    <x-input-label class="text-custom-brown" for="password_confirmation" :value="__('Confirm Password')" />
                                    <x-text-input id="password_confirmation" class="form-control-custom w-full"
                                                 type="password"
                                                 name="password_confirmation" 
                                                 required autocomplete="new-password" />
                                    <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2 text-danger" />
                                </div>

                                <div class="d-flex justify-content-between align-items-center" class="text-custom-brown">
                                    <a class="text-sm text-muted" href="{{ route('login') }}">
                                        {{ __('Ya tienes una cuenta?') }}
                                    </a>

                                    <x-primary-button class="text-push-register" >
                                        {{ __('Register') }}
                                    </x-primary-button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- JavaScript Libraries -->
        <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

        @vite('resources/js/app.js')
    </body>
</html>