<?php

use App\Console\Commands\ImportarGeoreferencing;
use App\Http\Controllers\ImportacionController;
use App\Http\Controllers\ProducerController;
use App\Http\Controllers\TaskController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::resource('tasks', TaskController::class)->only('index','store','update','destroy');


// Route::resource('user', UserController::class);

Route::resource('users',ProducerController::class)->only('index');



Route::prefix('importar')->group(function (){
    Route::post('/todo', [ImportacionController::class, 'importarTodo']);

    Route::post('/productores',[ImportacionController::class, 'importarProductores']);

    Route::post('/parcelas', [ImportacionController::class, 'importarParcelas']);
    Route::post('/georeferenciaciones', [ImportacionController::class, 'importarGeoreferenciaciones']);
});