

<?php $__env->startSection('title', 'Majomut - Gestion de Productores'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1><i class="fas fa-users me-2"></i>Gestión de Productores</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" ><?php echo e($totalProducer); ?></h3>
                                <p class="mb-0">Total Productores</p>
                            </div>
                            <i class="fas fa-users fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" id="productores-activos"></h3>
                                <p class="mb-0">Activos</p>
                            </div>
                            <i class="fas fa-check-circle fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" ><?php echo e($transicion1); ?></h3>
                                <p class="mb-0">En Transición 1</p>
                            </div>
                            <i class="fas fa-exchange-alt fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" ><?php echo e($transicion2); ?></h3>
                                <p class="mb-0">En Transición 2</p>
                            </div>
                            <i class="fas fa-exchange-alt fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" ><?php echo e($transicion3); ?></h3>
                                <p class="mb-0">En Transición 3</p>
                            </div>
                            <i class="fas fa-exchange-alt fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" ><?php echo e($Organico); ?></h3>
                                <p class="mb-0">Orgánicos</p>
                            </div>
                            <i class="fas fa-certificate fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-cloud-download-alt me-2"></i>
                    Importar desde KoBoToolbox
                </h5>
            </div>
            <div class="card-body">
                <form id="form-importar">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="asset_id" value="<?php echo e(config('services.kobotoolbox.PADRON_ASSET_UID')); ?>">
                    
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <label class="form-label">Año</label>
                            <input type="number" class="form-control" name="year" 
                                value="<?php echo e(date('Y')); ?>" min="2020" max="<?php echo e(date('Y') + 1); ?>" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Usuario KoBo</label>
                            <input type="text" class="form-control" name="auth_credential" 
                                placeholder="" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Password</label>
                            <div class="input-group">
                                <input type="password" class="form-control" name="second_auth_credential" 
                                    placeholder="Password" required>
                                <button type="button" class="btn btn-outline-secondary" id="toggle-password">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Servidor</label>
                            <select class="form-select" name="server_url" required>
                                <option value="https://eu.kobotoolbox.org">Europa</option>
                                <option value="https://kf.kobotoolbox.org">Global</option>
                                <option value="https://kobo.humanitarianresponse.info">Humanitarian</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">&nbsp;</label>
                            <button type="button" class="btn btn-info w-100" id="btn-verificar">
                                <i class="fas fa-check-circle"></i> Verificar
                            </button>
                        </div>
                    </div>

                    <input type="hidden" name="auth_method" value="basic">

                    <div id="asset-info" class="alert alert-info d-none mb-3">
                        <div id="asset-details"></div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-success btn-lg" id="btn-importar" disabled>
                                <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                                <i class="fas fa-download me-2"></i>
                                Importar Datos
                            </button>
                            <button type="button" class="btn btn-outline-primary btn-lg ms-2" id="btn-actualizar">
                                <i class="fas fa-sync-alt"></i> Actualizar Vista
                            </button>
                        </div>
                    </div>
                    
                </form>
            </div>
        </div>

        <div class="row gy-3">
            <div class="col-md-12">
                <form class="form-floating" action="<?php echo e(route('productores.eliminar')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <label for="">Version:</label>
                    <input type="number" class="p-3 border rounded bg-light mb-3" name="version" required>
                    <button type="submit" class="btn btn-warning btn-lg ms-2 fas fa-sync-alt">Eliminar registros</button>

                </form>
            </div>
        </div>
        

        

        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">Distribución por Estatus</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="chart-estatus" height="300"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">Top 5 Regiones</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="chart-regiones" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-filter me-2"></i>Filtros</h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-2">
                        <label class="form-label">Año</label>
                        <select class="form-select" id="filtro-year">
                            <option value="">Todos</option>
                            <option value="2025">2025</option>
                            <option value="2024">2024</option>
                            <option value="2023">2023</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Región</label>
                        <select class="form-select" id="filtro-region">
                            <option value="">Todas</option>
                            <option value="">Chenalho</option>
                            <option value="">Todas</option>
                            <option value="">Todas</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Municipio</label>
                        <select class="form-select" id="filtro-municipio">
                            <option value="">Todos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estatus</label>
                        <select class="form-select" id="filtro-estatus">
                            <option value="">Todos</option>
                            <option value="Certificado">Certificado</option>
                            <option value="En transición">En transición</option>
                            <option value="Convencional">Convencional</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estado</label>
                        <select class="form-select" id="filtro-activo">
                            <option value="">Todos</option>
                            <option value="1">Activos</option>
                            <option value="0">Inactivos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <button class="btn btn-outline-secondary w-100" id="btn-limpiar-filtros">
                            <i class="fas fa-times"></i> Limpiar
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Listado de Productores</h3>

                <div class="card-tools">
                    <div class="btn-group mr-2">
                        <button type="button" class="btn btn-outline-info btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-columns"></i> Columnas a Exportar
                        </button>
                        <div class="dropdown-menu dropdown-menu-right p-3" style="min-width: 300px;" id="column-selector">
                            <h6 class="dropdown-header">Selecciona las columnas a exportar:</h6>
                            <div class="form-group mb-2">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="check-all-columns" checked>
                                    <label class="custom-control-label" for="check-all-columns">Seleccionar Todas</label>
                                </div>
                            </div>
                            <div id="column-checkboxes" style="max-height: 200px; overflow-y: auto;">
                            </div>
                            <div class="dropdown-divider"></div>
                            <button class="btn btn-primary btn-sm btn-block" id="apply-columns">Aplicar Selección</button>
                        </div>
                    </div>
                    
                    <button class="btn btn-outline-primary btn-sm mr-2" id="btn-exportar-excel">
                        <i class="fas fa-file-excel"></i> Exportar Excel
                    </button>
                    <button class="btn btn-outline-danger btn-sm mr-2" id="btn-exportar-pdf">
                        <i class="fas fa-file-pdf"></i> Exportar PDF
                    </button>
                    <button class="btn btn-primary btn-sm" id="reload">
                        <i class="fas fa-sync-alt"></i> Recargar
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="tabla-productores" class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            
                            <th>ID</th>
                            <th>ID Productor</th>
                            <th>Fecha de importacion</th>
                            <th>Localidad</th>
                            <th>Municipio</th>
                            <th>Región</th>
                            <th>Socio</th>
                            <th>Grupo de trabajo</th>
                            <th>Curp</th>
                            <th>Rfc</th>
                            <th>Ine</th>
                            <th>Folio cafetalero</th>
                            <th>Folio suri</th>
                            <th>Fecha de nacimiento</th>
                            <th>Género</th>
                            <th>Estatus actual</th>
                            <th>Estatus</th>
                            <th>Categoria pasada</th>
                            <th>Ingreso</th>
                            <th>Transición</th>
                            <th>Numero de parcelas</th>
                            <th>Activo</th>
                            <th>Fecha Envío</th>
                            <th>Version</th>
                            <th>Accion</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            
                            <th>ID</th>
                            <th>ID Productor</th>
                            <th>Fecha de importacion</th>
                            <th>Localidad</th>
                            <th>Municipio</th>
                            <th>Región</th>
                            <th>Socio</th>
                            <th>Grupo de trabajo</th>
                            <th>Curp</th>
                            <th>Rfc</th>
                            <th>Ine</th>
                            <th>Folio cafetalero</th>
                            <th>Folio suri</th>
                            <th>Fecha de nacimiento</th>
                            <th>Género</th>
                            <th>Estatus actual</th>
                            <th>Estatus</th>
                            <th>Categoria pasada</th>
                            <th>Ingreso</th>
                            <th>Transición</th>
                            <th>Numero de parcelas</th>
                            <th>Activo</th>
                            <th>Fecha Envío</th>
                            <th>Version</th>
                            <th>Accion</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal-detalles" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-user me-2"></i>Detalles del Productor
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="modal-detalles-content">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">

    <style>
        .card {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-2px);
        }
        .table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .spinner-custom {
            width: 1rem;
            height: 1rem;
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            max-width: 400px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>


    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


    <script>
    $(document).ready(function() {
        let tabla;
        let selectedColumns = [];
        let chartEstatus, chartRegiones;

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function initColumnSelector() {
            const container = $('#column-checkboxes');
            container.empty();

            const exportableColumns = [
                { index: 1, title: 'ID Productor' },
                { index: 2, title: 'Fecha Importación' },
                { index: 3, title: 'Localidad' },
                { index: 4, title: 'Municipio' },
                { index: 5, title: 'Región' },
                { index: 6, title: 'Socio' },
                { index: 7, title: 'Grupo Trabajo' },
                { index: 8, title: 'CURP' },
                { index: 9, title: 'RFC' },
                { index: 10, title: 'INE' },
                { index: 11, title: 'Folio Cafetalero' },
                { index: 12, title: 'Folio Suri' },
                { index: 13, title: 'Fecha Nacimiento' },
                { index: 14, title: 'Género' },
                { index: 15, title: 'Estatus_actual' },
                { index: 15, title: 'Estatus' },
                { index: 16, title: 'Categoría Pasada' },
                { index: 17, title: 'Ingreso' },
                { index: 18, title: 'Transición' },
                { index: 19, title: 'Número Parcelas' },
                { index: 20, title: 'Activo' },
                { index: 21, title: 'Fecha Envío' },
                { index: 22, title: 'Versión' }
            ];

            exportableColumns.forEach((col) => {
                const colId = `col-${col.index}`;
                container.append(`
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input column-checkbox" 
                               id="${colId}" data-index="${col.index}" checked>
                        <label class="custom-control-label" for="${colId}">${col.title}</label>
                    </div>
                `);
                selectedColumns.push(col.index);
            });

            $('#column-selector').on('click', function(e) {
                e.stopPropagation();
            });

            $('#check-all-columns').on('change', function(e) {
                e.stopPropagation();
                const isChecked = $(this).is(':checked');
                $('.column-checkbox').prop('checked', isChecked);
                selectedColumns = isChecked ? exportableColumns.map(c => c.index) : [];
            });

            $('.column-checkbox').on('change', function(e) {
                e.stopPropagation();
                const index = parseInt($(this).data('index'));
                const isChecked = $(this).is(':checked');
                
                if (isChecked) {
                    if (!selectedColumns.includes(index)) {
                        selectedColumns.push(index);
                    }
                } else {
                    selectedColumns = selectedColumns.filter(i => i !== index);
                }
                
                $('#check-all-columns').prop('checked', 
                    selectedColumns.length === exportableColumns.length
                );
            });

            $('#apply-columns').on('click', function(e) {
                e.stopPropagation();
                $('.dropdown-toggle').dropdown('toggle');
            });
        }

        function initDataTable() {
            tabla = $('#tabla-productores').DataTable({
                processing: true,
                scrollX: true,                
                serverSide: false,
                dom: 'Blfrtip',
                ajax: {
                    url: "<?php echo e(route('productores.datatables')); ?>",
                    dataSrc: ""
                },
                columns: [
                    { data: 'id', title: 'ID', visible: false },
                    { data: 'id_productor', title: 'ID Productor' },
                    { data: 'fecha_importacion', title: 'Fecha Importación' },
                    { data: 'localidad', title: 'Localidad' },
                    { data: 'municipio', title: 'Municipio' },
                    { data: 'region', title: 'Región' },
                    { data: 'socio', title: 'Socio' },
                    { data: 'grupo_trabajo', title: 'Grupo Trabajo' },
                    { data: 'curp', title: 'CURP' },
                    { data: 'rfc', title: 'RFC' },
                    { data: 'ine', title: 'INE' },
                    { data: 'folio_cafetalero', title: 'Folio Cafetalero' },
                    { data: 'folio_suri', title: 'Folio Suri' },
                    { data: 'fecha_nacimiento', title: 'Fecha Nacimiento' },
                    { data: 'genero', title: 'Género' },
                    { data: 'Estatus_actual', title: 'Estatus actual' },
                    { data: 'estatus', title: 'Estatus' },
                    { data: 'categoria_pasada', title: 'Categoría Pasada' },
                    { data: 'ingreso', title: 'Ingreso' },
                    { data: 'transicion', title: 'Transición' },
                    { data: 'numero_parcelas', title: 'Número Parcelas' },
                    {
                        data: 'activo',
                        title: 'Activo',
                        render: function(data, type, row) {
                            if (type === 'export') {
                                return data == 0 ? 'Baja' : 'Activo';
                            }
                            if (data == 0) {
                                return '<span class="badge badge-danger">Baja</span>';
                            } else {
                                return '<span class="badge badge-success">Activo</span>';
                            }
                        }
                    },
                    { data: '_submission_time', title: 'Fecha Envío' },
                    { data: 'version', title: 'Versión' },
                    {
                        data: null,
                        title: 'Acciones',
                        orderable: false,
                        exportable: false,
                        render: function (data, type, row) {
                            return `
                                <div class="btn-group" role="group">
                                    <button class="btn btn-sm btn-primary btn-editar" data-id="${row.id}" title="Editar">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-info btn-ver" data-id="${row.id}" title="Ver">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger btn-eliminar" data-id="${row.id}" title="Eliminar">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            `;
                        }
                    }
                ],
                buttons: [
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        className: 'd-none',
                        filename: function() {
                            return 'productores_export_' + new Date().toISOString().split('T')[0];
                        },
                        exportOptions: {
                            columns: function(idx, data, node) {
                                return selectedColumns.includes(idx);
                            },
                            orthogonal: 'export',
                            modifier: {
                                search: 'applied',
                                order: 'applied'
                            }
                        }
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        className: 'd-none',
                        filename: function() {
                            return 'productores_export_' + new Date().toISOString().split('T')[0];
                        },
                        exportOptions: {
                            columns: function(idx, data, node) {
                                return selectedColumns.includes(idx);
                            },
                            orthogonal: 'export',
                            modifier: {
                                search: 'applied',
                                order: 'applied'
                            }
                        }
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        className: 'd-none',
                        orientation: 'landscape',
                        pageSize: 'LEGAL',
                        filename: function() {
                            return 'productores_export_' + new Date().toISOString().split('T')[0];
                        },
                        exportOptions: {
                            columns: function(idx, data, node) {
                                return selectedColumns.includes(idx);
                            },
                            orthogonal: 'export',
                            modifier: {
                                search: 'applied',
                                order: 'applied'
                            }
                        },
                        customize: function(doc) {
                            doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                            doc.styles.tableHeader.fillColor = '#2980b9';
                            doc.styles.tableHeader.color = 'white';
                        }
                    }
                ],
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                rowCallback: function(row, data) {
                    if (data.activo == 0) {
                        $(row).addClass('table-danger');
                    }
                }
            });
        }

        function initCharts() {
            const ctxEstatus = document.getElementById('chart-estatus').getContext('2d');
            chartEstatus = new Chart(ctxEstatus, {
                type: 'doughnut',
                data: {
                    labels: [],
                    datasets: [{
                        data: [],
                        backgroundColor: ['#28a745', '#ffc107', '#17a2b8', '#6c757d']
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });

            const ctxRegiones = document.getElementById('chart-regiones').getContext('2d');
            chartRegiones = new Chart(ctxRegiones, {
                type: 'bar',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Productores',
                        data: [],
                        backgroundColor: '#007bff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }

        function cargarEstadisticas() {
            const year = $('#filtro-year').val() || new Date().getFullYear();
            
            $.get('/productores/estadisticas', { year: year })
                .done(function(data) {
                    $('#total-productores').text(data.total);
                    $('#productores-activos').text(data.activos);
                    $('#en-transicion').text(data.por_estatus['En transición'] || 0);
                    $('#certificados').text(data.por_estatus['Certificado'] || 0);

                    if (chartEstatus) {
                        chartEstatus.data.labels = Object.keys(data.por_estatus);
                        chartEstatus.data.datasets[0].data = Object.values(data.por_estatus);
                        chartEstatus.update();
                    }

                    if (chartRegiones) {
                        chartRegiones.data.labels = Object.keys(data.por_region).slice(0, 5);
                        chartRegiones.data.datasets[0].data = Object.values(data.por_region).slice(0, 5);
                        chartRegiones.update();
                    }
                })
                .fail(function(xhr) {
                    console.error('Error al cargar estadísticas:', xhr);
                    showNotification('Error al cargar estadísticas', 'error');
                });
        }

        function showNotification(message, type) {
            const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
            const icon = type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-triangle';
            
            const notification = $(`
                <div class="alert ${alertClass} alert-dismissible fade show notification" style="position: fixed; top: 20px; right: 20px; z-index: 9999;">
                    <i class="${icon} me-2"></i>
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            `);
            
            $('body').append(notification);
            setTimeout(() => notification.alert('close'), 5000);
        }

        $('#btn-exportar-excel').on('click', function() {
            if (selectedColumns.length === 0) {
                alert('Por favor, selecciona al menos una columna para exportar.');
                return;
            }
            tabla.button(0).trigger();
            showNotification('Exportando a Excel...', 'success');
        });

        $('#btn-exportar-csv').on('click', function() {
            if (selectedColumns.length === 0) {
                alert('Por favor, selecciona al menos una columna para exportar.');
                return;
            }
            tabla.button(1).trigger();
            showNotification('Exportando a CSV...', 'success');
        });

        $('#btn-exportar-pdf').on('click', function() {
            if (selectedColumns.length === 0) {
                alert('Por favor, selecciona al menos una columna para exportar.');
                return;
            }
            tabla.button(2).trigger();
            showNotification('Exportando a PDF...', 'success');
        });

        $('#toggle-password').on('click', function() {
            const input = $('input[name="second_auth_credential"]');
            const icon = $(this).find('i');
            
            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            } else {
                input.attr('type', 'password');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            }
        });

        $('#btn-verificar').on('click', function() {
            const formData = {
                auth_method: 'basic',
                auth_credential: $('input[name="auth_credential"]').val(),
                second_auth_credential: $('input[name="second_auth_credential"]').val(),
                asset_id: $('input[name="asset_id"]').val(),
                server_url: $('select[name="server_url"]').val(),
                year: $('input[name="year"]').val()
            };

            if (!formData.auth_credential || !formData.second_auth_credential) {
                showNotification('Por favor completa todos los campos requeridos', 'error');
                return;
            }

            const btn = $(this);
            btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Verificando...');

            $.post('/productores/info-asset', formData)
                .done(function(response) {
                    if (response.success) {
                        $('#asset-info').removeClass('d-none');
                        $('#asset-details').html(`
                            <strong>Asset:</strong> ${response.name}<br>
                            <strong>Registros:</strong> ${response.deployment_count}<br>
                            <strong>Modificado:</strong> ${response.date_modified ? new Date(response.date_modified).toLocaleString('es-ES') : 'N/A'}
                        `);
                        $('#btn-importar').prop('disabled', false);
                        showNotification('Credenciales verificadas correctamente', 'success');
                    } else {
                        $('#asset-info').addClass('d-none');
                        showNotification('Error: ' + response.message, 'error');
                    }
                })
                .fail(function(xhr) {
                    $('#asset-info').addClass('d-none');
                    const message = xhr.responseJSON?.message || 'Error desconocido';
                    showNotification('Error al verificar: ' + message, 'error');
                })
                .always(function() {
                    btn.prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verificar');
                });
        });

        $('#form-importar').on('submit', function(e) {
            e.preventDefault();
            
            const formData = {
                year: $('input[name="year"]').val(),
                auth_method: 'basic',
                auth_credential: $('input[name="auth_credential"]').val(),
                second_auth_credential: $('input[name="second_auth_credential"]').val(),
                asset_id: $('input[name="asset_id"]').val(),
                server_url: $('select[name="server_url"]').val()
            };

            const btn = $('#btn-importar');
            const spinner = btn.find('.spinner-border');
            
            btn.prop('disabled', true);
            spinner.removeClass('d-none');
            btn.find('i.fa-download').addClass('d-none');
            
            $.post('/productores/importar-kobo', formData)
                .done(function(response) {
                    if (response.success) {
                        showNotification(`Importación exitosa: ${response.total} registros importados`, 'success');
                        setTimeout(() => location.reload(), 2000);
                    } else {
                        showNotification('Error: ' + response.message, 'error');
                    }
                })
                .fail(function(xhr) {
                    const message = xhr.responseJSON?.message || 'Error desconocido';
                    showNotification('Error en la importación: ' + message, 'error');
                })
                .always(function() {
                    btn.prop('disabled', true);
                    spinner.addClass('d-none');
                    btn.find('i.fa-download').removeClass('d-none');
                });
        });

        $('#filtro-year').on('keyup', function() {
            tabla.column(2).search(this.value).draw();
        });

        $('#filtro-region').on('change', function() {
            tabla.column(5).search(this.value).draw();
        });

        $('#filtro-municipio').on('change', function() {
            tabla.column(4).search(this.value).draw();
        });

        $('#filtro-estatus').on('change', function() {
            tabla.column(15).search(this.value).draw();
        });

        $('#filtro-activo').on('change', function() {
            tabla.column(20).search(this.value).draw();
        });

        $('#btn-limpiar-filtros').on('click', function() {
            $('#filtro-year, #filtro-region, #filtro-municipio, #filtro-estatus, #filtro-activo').val('');
            if (tabla) {
                tabla.search('').columns().search('').draw();
            }
            cargarEstadisticas();
        });

        $('#reload, #btn-actualizar').on('click', function() {
            if (tabla) {
                tabla.ajax.reload();
                $(this).find('i').addClass('fa-spin');
                setTimeout(() => {
                    $(this).find('i').removeClass('fa-spin');
                }, 1000);
            }
        });
        
        $('#btn-eliminar').on('click', function(){
            if(tabla){
                tabla.ajax.delete();
            }
        });

        $('#tabla-productores tbody').on('click', '.btn-editar', function() {
            const id = $(this).data('id');
            console.log('Editar:', id);
        });

        $('#tabla-productores tbody').on('click', '.btn-ver', function() {
            const id = $(this).data('id');
            console.log('Ver:', id);
        });

        $('#tabla-productores tbody').on('click', '.btn-eliminar', function() {
            const id = $(this).data('id');
            if (confirm('¿Está seguro de eliminar este productor?')) {
                console.log('Eliminar:', id);
            }
        });

        initColumnSelector();
        initDataTable();
        initCharts();
        cargarEstadisticas();
    });
</script>
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SIC\resources\views/productores/index.blade.php ENDPATH**/ ?>