

<?php $__env->startSection('title', 'Majomut - Mapa de Polígonos'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Mapa de Polígonos</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12 mb-4">
        <div id="map"></div>
    </div>

    <div class="col-md-12">
        <div class="card">
            <div class="card-header text-black">
                <h4 class="mb-0">Listado de Polígonos</h4>
            </div>
            <div class="card-body">
                <table id="tablaPoligonos" class="table table-bordered table-hover table-striped">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>Código Parcela</th>
                            <th>Nombre Parcela</th>
                            <th>Socio</th>
                            <th>Localidad</th>
                            <th>Grupo de Trabajo</th>
                        </tr>
                    </thead>
                    <tbody id="tablaBody">
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="col-md-12 mb-4">
    <div class="card shadow-sm border-0">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0"><i class="fas fa-file-upload me-2"></i> Cargar puntos adicionales</h5>
        </div>
        <div class="card-body">
            <form id="formArchivo" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row g-3 align-items-center">
                    <div class="col-md-6">
                        <input type="file" name="archivo" accept=".json,.xlsx,.xls" class="form-control" required>
                    </div>
                    <div class="col-md-3">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-upload me-1"></i> Cargar al mapa
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <style>
        body { margin: 0; padding: 0; }
        #map {
            height: 85vh;
            width: 100%;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.2);
        }

        
        .selected-row {
            background-color: #f3d355 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://unpkg.com/@turf/turf@6/turf.min.js"></script>
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

    <script>
        var map = L.map('map', {
            center: [16.9, -92.5],
            zoom: 10,
        });

        var osm = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { attribution: '© OpenStreetMap' }).addTo(map);
        var esriSat = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}', { attribution: '© Esri' });
        var cartoLight = L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}{r}.png', {
            attribution: '© OpenStreetMap © CARTO'
        });
        var cartoDark = L.tileLayer('https://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}{r}.png', {
            attribution: '© OpenStreetMap © CARTO'
        });
        var poligonosLayer = L.layerGroup().addTo(map);

        L.control.layers({
            "OpenStreetMap": osm,
            "Satélite (Esri)": esriSat,
            "En tono blanco": cartoLight,
            "Shortbreat":cartoDark,
        }, {"Polígonos": poligonosLayer}).addTo(map);

        function getColor(grupo) {
            if (!grupo) return '#999999';
            grupo = grupo.trim();
            const colores = {
                'Acteal': '#1f77b4',
                'San_Juan_Cancuc': '#ff7f0e',
                'Pechiquil': '#2ca02c',
                'Tzajalhucum': '#d62728',
                'Polho_Majumpepentik_3': '#C5C954'
            };
            return colores[grupo] || '#1F5BFF';
        }

        let featureLayers = {};
        let selectedLayer = null;

        fetch('<?php echo e(route('georeferenciacion.getPoligonos')); ?>')
        .then(response => response.json())
        .then(data => {
            if (data.type === 'FeatureCollection') {
                let tbody = document.getElementById('tablaBody');
                tbody.innerHTML = '';

                var geojson = L.geoJSON(data, {
                    style: f => ({
                        color: getColor(f.properties.grupo_trabajo),
                        weight: 2,
                        fillColor: getColor(f.properties.grupo_trabajo),
                        fillOpacity: 0.4
                    }),
                    onEachFeature: (f, layer) => {
                        const p = f.properties;
                        let popup = `
                            <b>Código Parcela:</b> ${p.codigo_parcela}<br>
                            <b>Nombre de Parcela:</b> ${p.nombre_parcela}<br>
                            <b>Socio:</b> ${p.socio}<br>
                            <b>Localidad:</b> ${p.localidad}<br>
                            <b>Grupo:</b> ${p.grupo_trabajo ?? 'N/A'}
                        `;
                        layer.bindPopup(popup);

                        featureLayers[p.codigo_parcela] = layer;

                        let row = `
                            <tr data-codigo="${p.codigo_parcela}">
                                <td></td>
                                <td>${p.codigo_parcela}</td>
                                <td>${p.nombre_parcela}</td>
                                <td>${p.socio}</td>
                                <td>${p.localidad}</td>
                                <td>${p.grupo_trabajo ?? 'N/A'}</td>
                            </tr>
                        `;
                        tbody.insertAdjacentHTML('beforeend', row);
                    }
                }).addTo(poligonosLayer);

                if (data.features.length > 0) map.fitBounds(geojson.getBounds());

                var tabla = $('#tablaPoligonos').DataTable({
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
                    },
                    columnDefs: [{
                        searchable: false,
                        orderable: false,
                        targets: 0
                    }],
                    order: [[1, 'asc']]
                });

                tabla.on('order.dt search.dt', function () {
                    let i = 1;
                    tabla.cells(null, 0, { search: 'applied', order: 'applied' }).every(function () {
                        this.data(i++);
                    });
                }).draw();

                $('#tablaPoligonos tbody').on('click', 'tr', function () {
                    // $('#tablaPoligonos tbody tr').removeClass('selected-row');
                    // $(this).addClass('selected-row');

                    let codigo = $(this).data('codigo');
                    let layer = featureLayers[codigo];

                    if ($(this).hasClass('selected-row')) {
                        $(this).removeClass('selected-row');
                        
                        if (selectedLayer) {
                            selectedLayer.setStyle({
                                color: getColor(selectedLayer.feature.properties.grupo_trabajo),
                                weight: 2
                            });
                            selectedLayer.closePopup();
                            selectedLayer = null;
                        }
                        return;
                    }

                    $('#tablaPoligonos tbody tr').removeClass('selected-row');
                    
                    if (selectedLayer) {
                        selectedLayer.setStyle({
                            color: getColor(selectedLayer.feature.properties.grupo_trabajo),
                            weight: 2
                        });
                        selectedLayer.closePopup();
                    }

                    $(this).addClass('selected-row');

                    if (layer) {

                        selectedLayer = layer;
                        map.fitBounds(layer.getBounds(), { maxZoom: 19 });
                        layer.openPopup();

                        layer.setStyle({ color: 'yellow', weight: 4 });
                        // setTimeout(() => {
                        //     layer.setStyle({
                        //         color: getColor(layer.feature.properties.grupo_trabajo),
                        //         weight: 2
                        //     });
                        // }, 30000);
                    }
                });
            }
        })
        .catch(err => console.error('Error al obtener los polígonos:', err));
    </script>

    
    

    
    <script>
        const puntosLayer = L.layerGroup().addTo(map);

        document.querySelector('#formArchivo').addEventListener('submit', async e =>{
            e.preventDefault();
            const formData = new FormData(e.target);
            const res = await fetch('<?php echo e(route("georeferenciacion.subir.mapa")); ?>',{
                method: 'POST',
                body: formData
            });

            const data = await res.json();

            puntosLayer.clearLayers();

            if (data.length) {
                data.forEach(p => {
                    if (p.lat && p.lng) {
                        L.circleMarker([p.lat, p.lng], {
                            radius: 6,
                            fillColor: "#ff7800",
                            color: "#000",
                            weight: 1,
                            opacity: 1,
                            fillOpacity: 0.8
                        })
                        .addTo(puntosLayer)
                        .bindPopup(`<b>${p.nombre}</b><br>Lat: ${p.lat}<br>Lng: ${p.lng}`);
                    }
                });
                map.fitBounds(puntosLayer.getBounds());
            } else {
                alert('No se encontraron puntos válidos en el archivo.');
            }
    
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SIC\resources\views/Georeferenciacion/mapa.blade.php ENDPATH**/ ?>