

<?php $__env->startSection('title', 'Majomut - Formato de Mapa'); ?>

<?php $__env->startSection('content_header'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <button id="print-button" onclick="window.print()" class="btn btn-primary mb-3 no-print">
        <i class="fas fa-print"></i> Imprimir Formato
    </button>

    <div class="print-container">
        <div class="card no-print">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('georeferenciacion.mapaformato')); ?>" class="form-inline">
                    <label for="search_id_parcela" class="mr-2">Buscar por ID de Parcela:</label>
                    <input type="text" id="search_id_parcela" name="search_id_parcela" 
                           value="<?php echo e($currentSearchId ?? ''); ?>" class="form-control mr-2" required>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Buscar
                    </button>
                </form>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show no-print">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show no-print">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-exclamation-circle"></i> <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(isset($message)): ?>
            <div class="alert <?php echo e(str_contains($message, 'No se encontró') ? 'alert-warning' : 'alert-info'); ?> alert-dismissible fade show no-print">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <div class="header">
            <div class="logo-title">
                <img src="<?php echo e(asset('img/LOGO.png')); ?>" alt="Logo Majomut" class="logo-img">
                <h1>UNION DE PRODUCTORES ORGANICOS BENEFICIO MAJOMUT S.P.R DE R.L.</h1>
            </div>
            <p class="subtitle">DATOS VALIDADOS POR EL SIC MAJOMUT</p>
        </div>

        <?php if(isset($geoRecord)): ?>
            <?php
                $nombreSocio = $geoRecord['georeferenciacion/socio'] ?? null;
                $numeroParcela = $geoRecord['georeferenciacion/numero_parcela'] ?? null;
            ?>

            <?php if($nombreSocio && trim($nombreSocio) != ""): ?>
                <div class="socio-nombre">
                    <?php echo e(str_replace('_', ' ', $nombreSocio)); ?>

                    <?php if($numeroParcela && trim($numeroParcela) != ""): ?>
                        <?php echo e(str_replace('_', ' ', $numeroParcela)); ?>

                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>

       <div class="map-symbols-section">
            <div class="map-container">
                <div class="section-title">Mapa de la Parcela</div>
                <div id="map">
                    <div class="cardinal-points">
                        <span class="cardinal-n">N</span>
                        <span class="cardinal-s">S</span>
                        <span class="cardinal-e">E</span>
                        <span class="cardinal-w">O</span>
                    </div>
                </div>
            </div>

            <div class="symbols-container">
                <div class="section-title">Simbología de objetos</div>
                <div class="symbols-content">
                    <img src="<?php echo e(asset('img/simbolos.png')); ?>" alt="Simbología del mapa" class="symbols-img">
                </div>
            </div>
        </div>

        <?php if(isset($geoRecord)): ?>
            <div class="update-section no-print">
                <h3><i class="fas fa-map-marker-alt"></i> Modificar Punto Central</h3>
                <p>Haz clic en el mapa y arrastra el marcador rojo para mayor precisión</p>
                
                <div id="new-location-info" class="location-info">
                    <i class="fas fa-info-circle"></i> Haga clic en el mapa para seleccionar un punto...
                </div>
                
                <form id="update-form" method="POST" action="<?php echo e(route('georeferenciacion.updateLocation')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="record_id" value="<?php echo e($geoRecord['_id'] ?? ''); ?>">
                    <input type="hidden" name="search_id_parcela" value="<?php echo e($currentSearchId ?? ''); ?>">
                    <input type="hidden" id="new_gps_coords" name="new_gps_coords" value="">
                    
                    <button type="submit" id="save-location-button" class="btn btn-success" disabled>
                        <i class="fas fa-save"></i> Guardar Nueva Ubicación
                    </button>
                </form>
            </div>
        <?php endif; ?>

        <div class="data-tables">
            <div class="table-wrapper">
                <?php if(isset($geoRecord)): ?>
                    <div class="section-title">Datos de georeferenciación y padrón</div>
                    <table class="data-table">
                        <tbody>
                            <?php $__currentLoopData = $geoHeaders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $headerName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($headerName); ?></th>
                                <td>
                                    <?php
                                        $value = $geoRecord[$key] ?? 'N/A';
                                    ?>
                                    <?php if(is_string($value)): ?>
                                        <?php echo e(str_replace('_', ' ', $value)); ?>

                                    <?php else: ?>
                                        <?php echo e($value); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php elseif(isset($currentSearchId) && !isset($message)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> No se encontraron datos de georreferenciación para el ID de parcela buscado.
                    </div>
                <?php endif; ?>
            </div>

            <div class="table-wrapper">
                <?php if(isset($parcelaRecord)): ?>
                    <div class="section-title">Datos de parcela</div>
                    <table class="data-table">
                        <tbody>
                            <?php $__currentLoopData = $parcelaHeaders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $headerName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($headerName); ?></th>
                                <td><?php echo e($parcelaRecord[$key] ?? 'N/A'); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php elseif(isset($geoRecord) && !isset($message)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> No se encontró un registro de parcela coincidente para el código <?php echo e($geoRecord['georeferenciacion/codigo_parcela'] ?? 'desconocido'); ?>.
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="plants-tables-container">
            <div class="plants-table-wrapper">
                <div class="section-title">Número de plantas</div>
                <table class="plants-table">
                    <thead>
                        <tr>
                            <th width="10%">Producción por niveles (%)</th>
                            <th width="25%">Numero de plantas</th>
                            <th width="25%">Distancia de siembra</th>
                            <th width="25%">Variedad</th>
                            <th width="25%">Año de siembra</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="plant-level">N1=</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="plant-level">N2=</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td class="plant-level">N3=</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="plants-table-wrapper large-table">
                <div class="section-title">Número de plantillas improductivas</div>
                <table class="plants-table large-table">
                    <thead>
                        <tr>
                            <th width="33%">Numero de plantillas</th>
                            <th width="33%">Distancia de siembra</th>
                            <th width="33%">Variedad</th>
                            <th width="34%">Año de siembra</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                        </tr>
                        <tr>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                        </tr>
                        <tr>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                            <td class="large-cell"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <style>
        .print-container {
            background-color: white;
            padding: 15px;
            max-width: 210mm;
            margin: 0 auto;
            font-family: Arial, sans-serif;
        }

        .header {
            text-align: center;
            margin-bottom: 12px;
            padding-bottom: 8px;
            border-bottom: 2px solid #000;
        }

        .logo-title {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 25px;
            margin-bottom: 1px;
        }

        .logo-img {
            height: 60px;
            width: auto;
        }

        .header h1 {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            line-height: 1.3;
            margin: 0;
            text-transform: uppercase;
        }

        .header .subtitle {
            font-size: 16px;
            color: #000;
            margin-top: 3px;
            font-weight: bold;
        }

        .socio-nombre {
            text-align: center;
            font-size: 13px;
            font-weight: bold;
            margin: 10px 0 12px 0;
            text-transform: uppercase;
            padding: 8px;
            border: 2px solid #000;
            background-color: #f8f9fa;
        }

        .section-title {
            background-color: #fff;
            padding: 6px;
            font-weight: bold;
            font-size: 11px;
            text-align: center;
            border: 1px solid #000;
            margin-bottom: 5px;
        }

        .map-symbols-section {
            display: flex;
            gap: 12px;
            margin-bottom: 15px;
            align-items: flex-start;
        }

        .map-container {
            flex: 0 0 58%;
        }

        #map {
            width: 100%;
            height: 300px;
            border: 2px solid #000;
            position: relative;
            background-color: #f5f5f5;
        }

        .cardinal-points {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 1000;
        }

        .cardinal-points span {
            position: absolute;
            background-color: rgba(255, 255, 255, 0.95);
            padding: 3px 8px;
            font-weight: bold;
            font-size: 12px;
            border: 1px solid #000;
        }

        .cardinal-n { top: 8px; left: 50%; transform: translateX(-50%); }
        .cardinal-s { bottom: 8px; left: 50%; transform: translateX(-50%); }
        .cardinal-e { top: 50%; right: 8px; transform: translateY(-50%); }
        .cardinal-w { top: 50%; left: 8px; transform: translateY(-50%); }

        .symbols-container {
            flex: 0 0 40%;
            border: 2px solid #000;
            padding: 8px;
        }

        .symbols-content {
            text-align: center;
        }

        .symbols-img {
            max-width: 100%;
            height: auto;
        }

        .data-tables {
            display: flex;
            gap: 12px;
            margin-bottom: 15px;
        }

        .table-wrapper {
            flex: 1;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
        }

        .data-table th, 
        .data-table td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: left;
            line-height: 1.4;
        }

        .data-table th {
            background-color: #f8f9fa;
            font-weight: bold;
            width: 45%;
        }

        .data-table td {
            width: 55%;
            word-break: break-word;
        }

        .plants-tables-container {
            display: flex;
            gap: 12px;
            margin-top: 15px;
        }

        .plants-table-wrapper {
            flex: 1;
        }

        .plants-table-wrapper.large-table {
            flex: 1.2;
        }

        .plants-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
            min-width: 0;
        }

        .plants-table th,
        .plants-table td {
            border: 1px solid #000;
            padding: 10px;
            text-align: center;
            font-weight: normal;
            height: 40px;
        }

        .plants-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }

        .plant-level {
            font-weight: bold;
            background-color: #f8f9fa;
        }

        .plants-table.large-table th,
        .plants-table.large-table td {
            height: 50px;
            padding: 12px;
        }

        .large-cell {
            min-height: 30px;
            vertical-align: top;
        }
        .update-section {
            background-color: #fff3cd;
            border: 1px solid #ffc107;
            border-radius: 4px;
            padding: 12px;
            margin-bottom: 15px;
        }

        .update-section h3 {
            font-size: 14px;
            margin-bottom: 8px;
            color: #856404;
        }

        .update-section p {
            font-size: 12px;
            color: #666;
            margin-bottom: 8px;
        }

        .location-info {
            background-color: #d1ecf1;
            border: 1px solid #bee5eb;
            border-radius: 3px;
            padding: 10px;
            margin-bottom: 12px;
            font-size: 12px;
            color: #0c5460;
        }

        @media print {
            @page {
                size: A4;
                margin: 15mm;
            }

            body {
                background-color: white !important;
                font-size: 20px !important;
                line-height: 1.7;
            }

            .no-print {
                display: none !important;
            }

            .print-container {
                padding: 0;
                max-width: 100%;
                margin: 0;
            }

            .header {
                margin-bottom: 10px;
                padding-bottom: 6px;
            }

            .logo-img {
                height: 65px;
            }

            .header h1 {
                font-size: 19px;
            }

            .header .subtitle {
                font-size: 16px;
            }

            .socio-nombre {
                font-size: 16px;
                margin: 8px 0 10px 0;
                padding: 6px;
            }

            .section-title {
                font-size: 16px;
                padding: 5px;
                margin-bottom: 4px;
            }

            .map-symbols-section {
                gap: 10px;
                margin-bottom: 12px;
            }

            #map {
                height: 300px;
                border-width: 1px;
            }

            .symbols-container {
                padding: 6px;
                border-width: 1px;
            }

            .data-tables {
                gap: 10px;
                margin-bottom: 12px;
            }

            .data-table {
                font-size: 13px;
            }

            .data-table th, 
            .data-table td {
                padding: 5px 6px;
            }

            .plants-tables-container {
                gap: 10px 20px;
                margin-top: 12px;
            }

            .plants-table {
                font-size: 16px;
            }

            .plants-table th,
            .plants-table td {
                padding: 8px;
                height: 38px;
            }

            .plants-table.large-table th,
            .plants-table.large-table td {
                height: 38px;
                padding: 8px;
            }

            .leaflet-control-container {
                display: none !important;
            }

            .cardinal-points span {
                font-size: 18px;
                padding: 2px 6px;
            }

            * {
                color: #000 !important;
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
        }

        @media screen {
            .print-container {
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                border: 1px solid #ddd;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script>
        console.log("Datos iniciales:");
        console.log("centerCoords:", <?php echo json_encode($centerCoords ?? null, 15, 512) ?>);
        console.log("polygonCoords:", <?php echo json_encode($polygonCoords ?? [], 15, 512) ?>);
        
        const geoRecordExists = <?php echo e(isset($geoRecord) ? 'true' : 'false'); ?>;
        const centerCoords = <?php echo json_encode($centerCoords ?? null, 15, 512) ?>;
        const polygonCoords = <?php echo json_encode($polygonCoords ?? [], 15, 512) ?>;
        const defaultMapCenter = <?php echo json_encode($defaultMapCenter ?? [16.9202568, -92.5100693], 512) ?>;
        const defaultMapZoom = <?php echo e($defaultMapZoom ?? 14); ?>;
        const currentSearchId = "<?php echo e($currentSearchId ?? ''); ?>";

        let map; 
        let parcelFeatures;
        let newLocationMarker = null;

        const newLocationInfoBox = document.getElementById('new-location-info');
        const saveLocationButton = document.getElementById('save-location-button');
        const newGpsCoordsInput = document.getElementById('new_gps_coords');

        const streetsLayer = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap', maxZoom: 20
        });

        const satelliteLayer = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}', {
            attribution: '© Esri', maxZoom: 19
        });
        
        const terrainLayer = L.tileLayer('https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap, SRTM | © OpenTopoMap', maxZoom: 17
        });

        const baseMaps = {
            "Calles": streetsLayer,
            "Satélite": satelliteLayer,
            "Terreno": terrainLayer,
        };

        const redIcon = new L.Icon({
            iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-2x-red.png',
            shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/0.7.7/images/marker-shadow.png',
            iconSize: [25, 41], iconAnchor: [12, 41], popupAnchor: [1, -34], shadowSize: [41, 41]
        });

        async function fetchElevation(lat, lng) {
            if (!newLocationInfoBox) return;
            
            newLocationInfoBox.innerHTML = `<i class="fas fa-spinner fa-spin"></i> Lat: ${lat.toFixed(6)}, Lon: ${lng.toFixed(6)}<br><em>Cargando altitud...</em>`;
            newLocationInfoBox.className = 'location-info';
            if (saveLocationButton) saveLocationButton.disabled = true;
            
            const apiUrl = `https://api.open-meteo.com/v1/elevation?latitude=${lat}&longitude=${lng}`;
            
            try {
                const response = await fetch(apiUrl);
                if (!response.ok) throw new Error(`Error: ${response.statusText}`);
                
                const data = await response.json();
                const elevation = data.elevation[0];
                const koboGpsString = `${lat.toFixed(6)} ${lng.toFixed(6)} ${elevation.toFixed(2)} 5.0`;

                newLocationInfoBox.innerHTML = `<strong>Latitud:</strong> ${lat.toFixed(6)}<br><strong>Longitud:</strong> ${lng.toFixed(6)}<br><strong>Altitud:</strong> ${elevation.toFixed(2)} m`;
                newLocationInfoBox.style.backgroundColor = '#d4edda';
                newLocationInfoBox.style.borderColor = '#c3e6cb';
                newLocationInfoBox.style.color = '#155724';
                if (newGpsCoordsInput) newGpsCoordsInput.value = koboGpsString;
                if (saveLocationButton) saveLocationButton.disabled = false;

            } catch (error) {
                console.error("Error al obtener altitud:", error);
                newLocationInfoBox.innerHTML = `<i class="fas fa-exclamation-triangle"></i> <strong>Error al obtener altitud</strong><br>Lat: ${lat.toFixed(6)}, Lon: ${lng.toFixed(6)}`;
                newLocationInfoBox.style.backgroundColor = '#fff3cd';
                newLocationInfoBox.style.borderColor = '#ffeeba';
                newLocationInfoBox.style.color = '#856404';
                if (saveLocationButton) saveLocationButton.disabled = true;
            }
        }

        function onMarkerDragEnd(event) {
            const marker = event.target;
            const position = marker.getLatLng();
            map.panTo(position);
            fetchElevation(position.lat, position.lng);
        }
        
        function onMapClick(e) {
            const lat = e.latlng.lat;
            const lng = e.latlng.lng;

            if (!newLocationMarker) {
                newLocationMarker = L.marker([lat, lng], { 
                    icon: redIcon,
                    draggable: true
                }).addTo(map);
                newLocationMarker.bindPopup('<strong>Nueva ubicación</strong><br>Arrastra para ajustar').openPopup();
                newLocationMarker.on('dragend', onMarkerDragEnd);
            } else {
                newLocationMarker.setLatLng([lat, lng]);
            }
            
            fetchElevation(lat, lng);
        }

        function initMap() {
            if (map) {
                map.remove(); 
                map = null;
            }
            
            if (!parcelFeatures) {
                parcelFeatures = L.layerGroup();
            } else {
                parcelFeatures.clearLayers();
            }

            map = L.map('map', {
                layers: [satelliteLayer, parcelFeatures]
            });

            const overlays = { "Datos de Parcela": parcelFeatures };
            L.control.layers(baseMaps, overlays).addTo(map);

            let boundsSet = false; 

            if (polygonCoords && Array.isArray(polygonCoords) && polygonCoords.length > 2) {
                const validPolygonPoints = polygonCoords.filter(p => 
                    Array.isArray(p) && p.length === 2 && 
                    typeof p[0] === 'number' && typeof p[1] === 'number'
                );
                
                if (validPolygonPoints.length > 2) {
                    try {
                        const polygon = L.polygon(validPolygonPoints, {color: 'blue', fillOpacity: 0.3});
                        parcelFeatures.addLayer(polygon);
                        map.fitBounds(polygon.getBounds()); 
                        boundsSet = true;
                    } catch (e) { 
                        console.error("Error al crear polígono:", e); 
                    }
                }
            }

            if (centerCoords && Array.isArray(centerCoords) && centerCoords.length === 2) {
                try {
                    const marker = L.marker(centerCoords).bindPopup('<strong>Ubicación central actual</strong>');
                    parcelFeatures.addLayer(marker);
                    if (!boundsSet) { 
                        map.setView(centerCoords, defaultMapZoom); 
                        boundsSet = true;
                    }
                } catch (e) { 
                    console.error("Error al crear marcador:", e); 
                }
            }
            
            if (!boundsSet) {
                map.setView(defaultMapCenter, currentSearchId ? defaultMapZoom : 9);
            }

            if (geoRecordExists) {
                map.on('click', onMapClick);
            }

            setTimeout(() => { 
                if(map) map.invalidateSize(false); 
            }, 100);
        }

        document.addEventListener('DOMContentLoaded', function() {
            initMap();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SIC\resources\views/Georeferenciacion/mapaformato.blade.php ENDPATH**/ ?>