

<?php $__env->startSection('title', 'Majomut - Georeferenciación'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1><i class="fas fa-globe-americas fa-2x opacity-75"> </i>Gestor de Georeferenciación</h1>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" ><?php echo e($TotalPoligono); ?></h3>
                                <p class="mb-0">Total de poligonos</p>
                            </div>
                            <i class="fas fa-users fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>

            <a href="<?php echo e(route('georeferenciacion.getactivos')); ?>" class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" ><?php echo e($PoligonosActivos); ?></h3>
                                <p class="mb-0">Poligonos activos</p>
                            </div>
                            <i class="fas fa-users fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </a>

            <div class="col-md-3">
                <a href="<?php echo e(route('georeferenciacion.indexmap')); ?>" class="text-decoration-none">
                    <div class="card bg-primary text-white h-70">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h3 class="mb-0">Georeferenciación</h3>
                                    <p class="mb-0">Mapa General</p>
                                </div>
                                <i class="fas fa-map-marker-alt fa-2x opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-md-3">
                <a href="<?php echo e(route('georeferenciacion.mapaformato')); ?>" class="text-decoration-none">
                    <div class="card bg-primary text-white h-70">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h3 class="mb-0">Formato Mapa</h3>
                                    <p class="mb-0">Generar Mapas</p>
                                </div>
                                <i class="fas fa-map-marked-alt fa-2x opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-md-3">
                <a href="javascript:void(0)" class="text-decoration-none" id="btn-ver-sin-poligono">
                    <div class="card bg-primary text-white h-70">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h3 class="mb-0"><?php echo e($parcelasSinPoligono); ?></h3>
                                    <p class="mb-0">Total sin poligono</p>
                                </div>
                                <i class="fas fa-map-marked-alt fa-2x opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-3">
                <a href="javascript:void(0)" class="text-decoration-none">
                    <div class="card bg-primary text-white h-70">
                        <div class="card-body">
                            <div class="d-flex justify-content-between aligen-items-center">
                                <div>
                                    <h1></h1>
                                    <h3 class="mb-0"><?php echo e($PoligonoNoActivos); ?></h3>
                                    <p class="mb-0"> Total poligono no activos</p>
                                </div>

                            </div>

                        </div>

                    </div>
                </a>

            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-cloud-download-alt me-2"></i>
                    Importar desde KoBoToolbox
                </h5>
            </div>
            <div class="card-body">
                <form id="form-importar">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="asset_id" value="<?php echo e(config('services.kobotoolbox.GEO_ASSET_UID')); ?>">
                    
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <label class="form-label">Año</label>
                            <input type="number" class="form-control" name="year" 
                                value="<?php echo e(date('Y')); ?>" min="2020" max="<?php echo e(date('Y') + 1); ?>" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Usuario KoBo</label>
                            <input type="text" class="form-control" name="auth_credential" 
                                placeholder="" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Password</label>
                            <div class="input-group">
                                <input type="password" class="form-control" name="second_auth_credential" 
                                    placeholder="Password" required>
                                <button type="button" class="btn btn-outline-secondary" id="toggle-password">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Servidor</label>
                            <select class="form-select" name="server_url" required>
                                <option value="https://eu.kobotoolbox.org">Europa</option>
                                <option value="https://kf.kobotoolbox.org">Global</option>
                                <option value="https://kobo.humanitarianresponse.info">Humanitarian</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">&nbsp;</label>
                            <button type="button" class="btn btn-info w-100" id="btn-verificar">
                                <i class="fas fa-check-circle"></i> Verificar
                            </button>
                        </div>
                    </div>

                    <input type="hidden" name="auth_method" value="basic">

                    <div id="asset-info" class="alert alert-info d-none mb-3">
                        <div id="asset-details"></div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-success btn-lg" id="btn-importar" disabled>
                                <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                                <i class="fas fa-download me-2"></i>
                                Importar Datos
                            </button>
                            <button type="button" class="btn btn-outline-primary btn-lg ms-2" id="btn-actualizar">
                                <i class="fas fa-sync-alt"></i> Actualizar Vista
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div> 

        <div class="card mb-3">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-filter me-2"></i>Filtros</h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-2">
                        <label class="form-label">Año</label>
                        <select class="form-select" id="filtro-year" data-index="3">
                            <option value="">Todos</option>
                            <option value="2025">2025</option>
                            <option value="2024">2024</option>
                            <option value="2023">2023</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Región</label>
                        <select class="form-select" id="filtro-region">
                            <option value="">Todas</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Municipio</label>
                        <select class="form-select" id="filtro-municipio">
                            <option value="">Todos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estatus</label>
                        <select class="form-select" id="filtro-estatus">
                            <option value="">Todos</option>
                            <option value="Certificado">Certificado</option>
                            <option value="En transición">En transición</option>
                            <option value="Convencional">Convencional</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estado</label>
                        <select class="form-select" id="filtro-activo">
                            <option value="">Todos</option>
                            <option value="1">Activos</option>
                            <option value="0">Inactivos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <button class="btn btn-outline-secondary w-100" id="btn-limpiar-filtros">
                            <i class="fas fa-times"></i> Limpiar
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Georeferenciación majomut</h3>
                <div class="card-tools">
                    <div class="btn-group mr-2">
                        <button type="button" class="btn btn-outline-info btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-columns"></i> Columnas a Exportar
                        </button>
                        <div class="dropdown-menu dropdown-menu-right p-3" style="min-width: 300px;" id="column-selector">
                            <h6 class="dropdown-header">Selecciona las columnas a exportar:</h6>
                            <div class="form-group mb-2">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="check-all-columns" checked>
                                    <label class="custom-control-label" for="check-all-columns">Seleccionar Todas</label>
                                </div>
                            </div>
                            <div id="column-checkboxes" style="max-height: 200px; overflow-y: auto;">
                            </div>
                            <div class="dropdown-divider"></div>
                            <button class="btn btn-primary btn-sm btn-block" id="apply-columns">Aplicar Selección</button>
                        </div>
                    </div>
                    
                    <button class="btn btn-outline-primary btn-sm mr-2" id="btn-exportar-excel">
                        <i class="fas fa-file-excel"></i> Exportar Excel
                    </button>
                    <button class="btn btn-outline-success btn-sm mr-2" id="btn-exportar-csv">
                        <i class="fas fa-file-csv"></i> Exportar CSV
                    </button>
                    <button class="btn btn-outline-danger btn-sm mr-2" id="btn-exportar-pdf">
                        <i class="fas fa-file-pdf"></i> Exportar PDF
                    </button>
                    <button class="btn btn-primary btn-sm" id="reload">
                        <i class="fas fa-sync-alt"></i> Recargar
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="tabla-poligonos" class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>id</th>
                            <th>start</th>
                            <th>end</th>
                            <th>today</th>
                            <th>username</th>
                            <th>deviceid</th>
                            <th>phonenumber</th>
                            <th>hora</th>
                            <th>horas</th>
                            <th>minutos</th>
                            <th>segundos</th>
                            <th>anos</th>
                            <th>mes</th>
                            <th>dias</th>
                            <th>id_record</th>
                            <th>promotor</th>
                            <th>dni</th>
                            <th>socio</th>
                            <th>localidad</th>
                            <th>municipio</th>
                            <th>numero_parcela</th>
                            <th>codigo_parcela</th>
                            <th>nombre_parcela</th>
                            <th>anio_inicio_cultivo</th>
                            <th>gps</th>
                            
                            <th>area_gps</th>
                            <th>area_gps_ha</th>
                            <th>are_gps_display</th>
                            <th>instanceID</th>
                            <th>rootUuid</th>
                            <th>inctanceName</th>
                            <th>starttime</th>
                            <th>endtime</th>
                            <th>p_nombre</th>
                            <th>ciclo codigo</th>
                            <th>subscriberid</th>
                            <th>simid</th>
                            <th>formhub uuid</th>
                            <th>version</th>
                            <th>xform id</th>
                            <th>uuid </th>
                            <th>attachments</th>
                            <th>status</th>
                            <th>geolocalización</th>
                            <th>submission_time</th>
                            <th>tags</th>
                            <th>notes</th>
                            <th>validation status</th>
                            <th>submitted by</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>ID</th>
                            <th>id</th>
                            <th>start</th>
                            <th>end</th>
                            <th>today</th>
                            <th>username</th>
                            <th>deviceid</th>
                            <th>phonenumber</th>
                            <th>hora</th>
                            <th>horas</th>
                            <th>minutos</th>
                            <th>segundos</th>
                            <th>anos</th>
                            <th>mes</th>
                            <th>dias</th>
                            <th>id_record</th>
                            <th>promotor</th>
                            <th>dni</th>
                            <th>socio</th>
                            <th>localidad</th>
                            <th>municipio</th>
                            <th>numero_parcela</th>
                            <th>codigo_parcela</th>
                            <th>nombre_parcela</th>
                            <th>anio_inicio_cultivo</th>
                            <th>gps</th>
                            
                            <th>area_gps</th>
                            <th>area_gps_ha</th>
                            <th>are_gps_display</th>
                            <th>instanceID</th>
                            <th>rootUuid</th>
                            <th>inctanceName</th>
                            <th>starttime</th>
                            <th>endtime</th>
                            <th>p_nombre</th>
                            <th>ciclo codigo</th>
                            <th>subscriberid</th>
                            <th>simid</th>
                            <th>formhub uuid</th>
                            <th>version</th>
                            <th>xform id</th>
                            <th>uuid </th>
                            <th>attachments</th>
                            <th>status</th>
                            <th>geolocalización</th>
                            <th>submission_time</th>
                            <th>tags</th>
                            <th>notes</th>
                            <th>validation status</th>
                            <th>submitted by</th>
                            <th>Acciones</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal-detalles" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-user me-2"></i>Detalles del
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="modal-detalles-content">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal-sin-poligono" tabindex="-1" aria-labelledby="modalSinPoligonoLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="modalSinPoligonoLabel">
                <i class="fas fa-map-marked-alt me-2"></i>Parcelas sin polígono
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="contenedor-sin-poligono" class="text-center py-3">
                <div class="spinner-border text-danger" role="status">
                    <span class="visually-hidden">Cargando...</span>
                </div>
                </div>
            </div>
            
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">

    <style>
        .card {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-2px);
        }
        .table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .spinner-custom {
            width: 1rem;
            height: 1rem;
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            max-width: 400px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>


    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


    <script>
        $(document).ready(function() {
            let tabla;
            let selectedColumns = [];

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // Inicializar selector de columnas
            function initColumnSelector() {
                const container = $('#column-checkboxes');
                container.empty();

                const exportableColumns = [
                    { index: 1, title: 'ID Kobo' },
                    { index: 2, title: 'Start' },
                    { index: 3, title: 'End' },
                    { index: 4, title: 'Today' },
                    { index: 5, title: 'Username' },
                    { index: 6, title: 'Device ID' },
                    { index: 7, title: 'Phone Number' },
                    { index: 8, title: 'Hora' },
                    { index: 9, title: 'Horas' },
                    { index: 10, title: 'Minutos' },
                    { index: 11, title: 'Segundos' },
                    { index: 12, title: 'Años' },
                    { index: 13, title: 'Mes' },
                    { index: 14, title: 'Días' },
                    { index: 15, title: 'ID Record' },
                    { index: 16, title: 'Promotor' },
                    { index: 17, title: 'DNI' },
                    { index: 18, title: 'Socio' },
                    { index: 19, title: 'Localidad' },
                    { index: 20, title: 'Municipio' },
                    { index: 21, title: 'Número Parcela' },
                    { index: 22, title: 'Código Parcela' },
                    { index: 23, title: 'Nombre Parcela' },
                    { index: 24, title: 'Año Inicio Cultivo' },
                    { index: 25, title: 'GPS' },
                    { index: 26, title: 'Área GPS' },
                    { index: 27, title: 'Área GPS (ha)' },
                    { index: 28, title: 'Área GPS Display' },
                    { index: 29, title: 'Instance ID' },
                    { index: 30, title: 'Root UUID' },
                    { index: 31, title: 'Instance Name' },
                    { index: 32, title: 'Start Time' },
                    { index: 33, title: 'End Time' },
                    { index: 34, title: 'P Nombre' },
                    { index: 35, title: 'Ciclo Código' },
                    { index: 36, title: 'Subscriber ID' },
                    { index: 37, title: 'SIM ID' },
                    { index: 38, title: 'Formhub UUID' },
                    { index: 39, title: 'Versión' },
                    { index: 40, title: 'XForm ID' },
                    { index: 41, title: 'UUID' },
                    { index: 42, title: 'Attachments' },
                    { index: 43, title: 'Status' },
                    { index: 44, title: 'Geolocalización' },
                    { index: 45, title: 'Submission Time' },
                    { index: 46, title: 'Tags' },
                    { index: 47, title: 'Notes' },
                    { index: 48, title: 'Validation Status' },
                    { index: 49, title: 'Submitted By' }
                ];

                exportableColumns.forEach((col) => {
                    const colId = `col-${col.index}`;
                    container.append(`
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input column-checkbox" 
                                id="${colId}" data-index="${col.index}" checked>
                            <label class="custom-control-label" for="${colId}">${col.title}</label>
                        </div>
                    `);
                    selectedColumns.push(col.index);
                });

                $('#column-selector').on('click', function(e) {
                    e.stopPropagation();
                });

                $('#check-all-columns').on('change', function(e) {
                    e.stopPropagation();
                    const isChecked = $(this).is(':checked');
                    $('.column-checkbox').prop('checked', isChecked);
                    selectedColumns = isChecked ? exportableColumns.map(c => c.index) : [];
                });

                $('.column-checkbox').on('change', function(e) {
                    e.stopPropagation();
                    const index = parseInt($(this).data('index'));
                    const isChecked = $(this).is(':checked');
                    
                    if (isChecked) {
                        if (!selectedColumns.includes(index)) {
                            selectedColumns.push(index);
                        }
                    } else {
                        selectedColumns = selectedColumns.filter(i => i !== index);
                    }
                    
                    $('#check-all-columns').prop('checked', 
                        selectedColumns.length === exportableColumns.length
                    );
                });

                $('#apply-columns').on('click', function(e) {
                    e.stopPropagation();
                    $('.dropdown-toggle').dropdown('toggle');
                });
            }

            function initDataTable() {
                tabla = $('#tabla-poligonos').DataTable({
                    processing: true,
                    scrollX: true,
                    serverSide: false,
                    dom: 'Blfrtip',
                    ajax: {
                        url: "<?php echo e(route('georeferenciacion.datatables')); ?>",
                        dataSrc: ""
                    },
                    columns: [
                        { data: 'id', title: 'ID', visible: false },
                        { data: '_id', title: 'ID Kobo' },
                        { data: 'start', title: 'Start' },
                        { data: 'end', title: 'End' },
                        { data: 'today', title: 'Today' },
                        { data: 'username', title: 'Username' },
                        { data: 'deviceid', title: 'Device ID' },
                        { data: 'phonenumber', title: 'Phone Number' },
                        { data: 'hora', title: 'Hora' },
                        { data: 'horas', title: 'Horas' },
                        { data: 'minutos', title: 'Minutos' },
                        { data: 'segundos', title: 'Segundos' },
                        { data: 'anos', title: 'Años' },
                        { data: 'mes', title: 'Mes' },
                        { data: 'dias', title: 'Días' },
                        { data: 'id_record', title: 'ID Record' },
                        { data: 'promotor', title: 'Promotor' },
                        { data: 'dni', title: 'DNI' },
                        { data: 'socio', title: 'Socio' },
                        { data: 'localidad', title: 'Localidad' },
                        { data: 'municipio', title: 'Municipio' },
                        { data: 'numero_parcela', title: 'Número Parcela' },
                        { data: 'codigo_parcela', title: 'Código Parcela' },
                        { data: 'nombre_parcela', title: 'Nombre Parcela' },
                        { data: 'anio_incio_cultivo', title: 'Año Inicio Cultivo' },
                        { data: 'gps', title: 'GPS' },
                        { data: 'area_gps', title: 'Área GPS' },
                        { data: 'area_gps_ha', title: 'Área GPS (ha)' },
                        { data: 'area_gps_display', title: 'Área GPS Display' },
                        { data: 'meta_instanceID', title: 'Instance ID' },
                        { data: 'meta_rootUuid', title: 'Root UUID' },
                        { data: 'meta_instanceName', title: 'Instance Name' },
                        { data: 'starttime', title: 'Start Time' },
                        { data: 'endtime', title: 'End Time' },
                        { data: 'p_nombre', title: 'P Nombre' },
                        { data: 'ciclo_codigo', title: 'Ciclo Código' },
                        { data: 'subscriberid', title: 'Subscriber ID' },
                        { data: 'simid', title: 'SIM ID' },
                        { data: 'formhub_uuid', title: 'Formhub UUID' },
                        { data: '__version__', title: 'Versión' },
                        { data: '_xform_id_string', title: 'XForm ID' },
                        { data: '_uuid', title: 'UUID' },
                        { data: '_attachments', title: 'Attachments' },
                        { data: '_status', title: 'Status' },
                        { data: '_geolocation', title: 'Geolocalización' },
                        { data: '_submission_time', title: 'Submission Time' },
                        { data: '_tags', title: 'Tags' },
                        { data: '_notes', title: 'Notes' },
                        { data: '_validation_status', title: 'Validation Status' },
                        { data: '_submitted_by', title: 'Submitted By' },
                        {
                            data: null,
                            title: 'Acciones',
                            orderable: false,
                            exportable: false,
                            render: function (data, type, row) {
                                return `
                                    <div class="btn-group" role="group">
                                        <button class="btn btn-sm btn-primary btn-editar" data-id="${row.id}" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-info btn-ver" data-id="${row.id}" title="Ver">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger btn-eliminar" data-id="${row.id}" title="Eliminar">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                `;
                            }
                        }
                    ],
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            className: 'd-none',
                            filename: function() {
                                return 'georeferenciacion_export_' + new Date().toISOString().split('T')[0];
                            },
                            exportOptions: {
                                columns: function(idx, data, node) {
                                    return selectedColumns.includes(idx);
                                },
                                orthogonal: 'export',
                                modifier: {
                                    search: 'applied',
                                    order: 'applied'
                                }
                            }
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            className: 'd-none',
                            filename: function() {
                                return 'georeferenciacion_export_' + new Date().toISOString().split('T')[0];
                            },
                            exportOptions: {
                                columns: function(idx, data, node) {
                                    return selectedColumns.includes(idx);
                                },
                                orthogonal: 'export',
                                modifier: {
                                    search: 'applied',
                                    order: 'applied'
                                }
                            }
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            className: 'd-none',
                            orientation: 'landscape',
                            pageSize: 'LEGAL',
                            filename: function() {
                                return 'georeferenciacion_export_' + new Date().toISOString().split('T')[0];
                            },
                            exportOptions: {
                                columns: function(idx, data, node) {
                                    return selectedColumns.includes(idx);
                                },
                                orthogonal: 'export',
                                modifier: {
                                    search: 'applied',
                                    order: 'applied'
                                }
                            },
                            customize: function(doc) {
                                doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                                doc.styles.tableHeader.fillColor = '#2980b9';
                                doc.styles.tableHeader.color = 'white';
                            }
                        }
                    ],
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                    }
                });
            }

            function showNotification(message, type) {
                const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
                const icon = type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-triangle';
                
                const notification = $(`
                    <div class="alert ${alertClass} alert-dismissible fade show notification" style="position: fixed; top: 20px; right: 20px; z-index: 9999;">
                        <i class="${icon} me-2"></i>
                        ${message}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                `);
                
                $('body').append(notification);
                setTimeout(() => notification.alert('close'), 5000);
            }

            // Botones de exportación
            $('#btn-exportar-excel').on('click', function() {
                if (selectedColumns.length === 0) {
                    alert('Por favor, selecciona al menos una columna para exportar.');
                    return;
                }
                tabla.button(0).trigger();
                showNotification('Exportando a Excel...', 'success');
            });

            $('#btn-exportar-csv').on('click', function() {
                if (selectedColumns.length === 0) {
                    alert('Por favor, selecciona al menos una columna para exportar.');
                    return;
                }
                tabla.button(1).trigger();
                showNotification('Exportando a CSV...', 'success');
            });

            $('#btn-exportar-pdf').on('click', function() {
                if (selectedColumns.length === 0) {
                    alert('Por favor, selecciona al menos una columna para exportar.');
                    return;
                }
                tabla.button(2).trigger();
                showNotification('Exportando a PDF...', 'success');
            });

            // Toggle password
            $('#toggle-password').on('click', function() {
                const input = $('input[name="second_auth_credential"]');
                const icon = $(this).find('i');
                
                if (input.attr('type') === 'password') {
                    input.attr('type', 'text');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                } else {
                    input.attr('type', 'password');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                }
            });

            // Verificar credenciales
            $('#btn-verificar').on('click', function() {
                const formData = {
                    auth_method: 'basic',
                    auth_credential: $('input[name="auth_credential"]').val(),
                    second_auth_credential: $('input[name="second_auth_credential"]').val(),
                    asset_id: $('input[name="asset_id"]').val(),
                    server_url: $('select[name="server_url"]').val(),
                    year: $('input[name="year"]').val()
                };

                if (!formData.auth_credential || !formData.second_auth_credential) {
                    showNotification('Por favor completa todos los campos requeridos', 'error');
                    return;
                }

                const btn = $(this);
                btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Verificando...');

                $.post('/georeferenciacion/info-asset', formData)
                    .done(function(response) {
                        if (response.success) {
                            $('#asset-info').removeClass('d-none');
                            $('#asset-details').html(`
                                <strong>Asset:</strong> ${response.name}<br>
                                <strong>Registros:</strong> ${response.deployment_count}<br>
                                <strong>Modificado:</strong> ${response.date_modified ? new Date(response.date_modified).toLocaleString('es-ES') : 'N/A'}
                            `);
                            $('#btn-importar').prop('disabled', false);
                            showNotification('Credenciales verificadas correctamente', 'success');
                        } else {
                            $('#asset-info').addClass('d-none');
                            showNotification('Error: ' + response.message, 'error');
                        }
                    })
                    .fail(function(xhr) {
                        $('#asset-info').addClass('d-none');
                        const message = xhr.responseJSON?.message || 'Error desconocido';
                        showNotification('Error al verificar: ' + message, 'error');
                    })
                    .always(function() {
                        btn.prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verificar');
                    });
            });

            // Importar datos
            $('#form-importar').on('submit', function(e) {
                e.preventDefault();
                
                const formData = {
                    year: $('input[name="year"]').val(),
                    auth_method: 'basic',
                    auth_credential: $('input[name="auth_credential"]').val(),
                    second_auth_credential: $('input[name="second_auth_credential"]').val(),
                    asset_id: $('input[name="asset_id"]').val(),
                    server_url: $('select[name="server_url"]').val()
                };

                const btn = $('#btn-importar');
                const spinner = btn.find('.spinner-border');
                
                btn.prop('disabled', true);
                spinner.removeClass('d-none');
                btn.find('i.fa-download').addClass('d-none');
                
                $.post('/georeferenciacion/importar-kobo', formData)
                    .done(function(response) {
                        if (response.success) {
                            showNotification(`Importación exitosa: ${response.total} registros importados`, 'success');
                            setTimeout(() => location.reload(), 2000);
                        } else {
                            showNotification('Error: ' + response.message, 'error');
                        }
                    })
                    .fail(function(xhr) {
                        const message = xhr.responseJSON?.message || 'Error desconocido';
                        showNotification('Error en la importación: ' + message, 'error');
                    })
                    .always(function() {
                        btn.prop('disabled', true);
                        spinner.addClass('d-none');
                        btn.find('i.fa-download').removeClass('d-none');
                    });
            });

            // Filtros
            $('#filtro-year').on('change', function() {
                tabla.column(4).search(this.value).draw();
            });

            $('#filtro-region').on('change', function() {
                tabla.column(19).search(this.value).draw();
            });

            $('#filtro-municipio').on('change', function() {
                tabla.column(20).search(this.value).draw();
            });

            $('#btn-limpiar-filtros').on('click', function() {
                $('#filtro-year, #filtro-region, #filtro-municipio, #filtro-estatus, #filtro-activo').val('');
                if (tabla) {
                    tabla.search('').columns().search('').draw();
                }
            });

            $('#reload, #btn-actualizar').on('click', function() {
                if (tabla) {
                    tabla.ajax.reload();
                    $(this).find('i').addClass('fa-spin');
                    setTimeout(() => {
                        $(this).find('i').removeClass('fa-spin');
                    }, 1000);
                }
            });

            // Modal parcelas sin polígono
            $('#btn-ver-sin-poligono').on('click', function() {
                $('#modal-sin-poligono').modal('show');

                const contenedor = $('#contenedor-sin-poligono');
                contenedor.html(`
                    <div class="spinner-border text-danger" role="status">
                        <span class="visually-hidden">Cargando...</span>
                    </div>
                `);

                $.get('<?php echo e(route("georeferenciacion.sinpoligono")); ?>', function(response) {
                    if (response.length > 0) {
                        let html = `
                            <table class="table table-striped table-sm">
                                <thead class="table-danger">
                                    <tr>
                                        <th>ID Parcela</th>
                                        <th>Productor</th>
                                        <th>Nombre</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;

                        response.forEach(item => {
                            html += `
                                <tr>
                                    <td>${item.id_parcela}</td>
                                    <td>${item.socio ?? '—'}</td>
                                    <td>${item.nombre_parcela ?? '—'}</td>
                                </tr>
                            `;
                        });

                        html += `</tbody></table>`;
                        contenedor.html(html);
                    } else {
                        contenedor.html(`<div class="alert alert-warning">No hay parcelas sin polígono.</div>`);
                    }
                }).fail(function() {
                    contenedor.html(`<div class="alert alert-danger">Error al cargar los datos.</div>`);
                });
            });

            // Inicializar
            initColumnSelector();
            initDataTable();
        });

    $('#btn-ver-sin-poligono').on('click', function() {
        $('#modal-sin-poligono').modal('show');

        const contenedor = $('#contenedor-sin-poligono');
        contenedor.html(`
            <div class="spinner-border text-danger" role="status">
                <span class="visually-hidden">Cargando...</span>
            </div>
        `);

        $.get('<?php echo e(route("georeferenciacion.sinpoligono")); ?>', function(response) {
            if (response.length > 0) {
                let html = `
                    <table class="table table-striped table-sm">
                        <thead class="table-danger">
                            <tr>
                                <th>ID Parcela</th>
                                <th>Productor</th>
                                <th>Nombre</th>
                            </tr>
                        </thead>
                        <tbody>
                `;

                response.forEach(item => {
                    html += `
                        <tr>
                            <td>${item.id_parcela}</td>
                            <td>${item.socio ?? '—'}</td>
                            <td>${item.nombre_parcela ?? '—'}</td>
                        </tr>
                    `;
                });

                html += `</tbody></table>`;
                contenedor.html(html);
            } else {
                contenedor.html(`<div class="alert alert-warning">No hay parcelas sin polígono.</div>`);
            }
        }).fail(function() {
            contenedor.html(`<div class="alert alert-danger">Error al cargar los datos.</div>`);
        });
    });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SIC\resources\views/Georeferenciacion/index.blade.php ENDPATH**/ ?>