

<?php $__env->startSection('title', 'Majomut - Georeferenciación'); ?>

<?php $__env->startSection('content_header'); ?>
    
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    
    <div class="card">
            <div class="card-header">
                <h3 class="card-title">Georeferenciación majomut</h3>
                <div class="card-tools">
                    
                    <button class="btn btn-primary btn-sm" id="reload">
                        <i class="fas fa-sync-alt"></i> Recargar
                    </button>
                    <button class="btn btn-outline-primary btn-sm mr-2" id="btn-exportar-excel">
                        <i class="fas fa-file-excel"></i> Exportar Excel
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="tabla-poligonos" class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>id</th>
                            <th>start</th>
                            <th>end</th>
                            <th>today</th>
                            <th>username</th>
                            <th>deviceid</th>
                            <th>phonenumber</th>
                            <th>hora</th>
                            <th>horas</th>
                            <th>minutos</th>
                            <th>segundos</th>
                            <th>anos</th>
                            <th>mes</th>
                            <th>dias</th>
                            <th>id_record</th>
                            <th>promotor</th>
                            <th>Grupo Trabajo</th>
                            <th>dni</th>
                            <th>socio</th>
                            <th>localidad</th>
                            <th>municipio</th>
                            <th>numero_parcela</th>
                            <th>codigo_parcela</th>
                            <th>nombre_parcela</th>
                            <th>anio_inicio_cultivo</th>
                            <th>gps</th>
                            <th>poligono</th>
                            <th>area_gps</th>
                            <th>area_gps_ha</th>
                            <th>are_gps_display</th>
                            <th>instanceID</th>
                            <th>rootUuid</th>
                            <th>inctanceName</th>
                            <th>starttime</th>
                            <th>endtime</th>
                            <th>p_nombre</th>
                            <th>ciclo codigo</th>
                            <th>subscriberid</th>
                            <th>simid</th>
                            <th>formhub uuid</th>
                            <th>version</th>
                            <th>xform id</th>
                            <th>uuid </th>
                            <th>attachments</th>
                            <th>status</th>
                            <th>geolocalización</th>
                            <th>submission_time</th>
                            <th>tags</th>
                            <th>notes</th>
                            <th>validation status</th>
                            <th>submitted by</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>ID</th>
                            <th>id</th>
                            <th>start</th>
                            <th>end</th>
                            <th>today</th>
                            <th>username</th>
                            <th>deviceid</th>
                            <th>phonenumber</th>
                            <th>hora</th>
                            <th>horas</th>
                            <th>minutos</th>
                            <th>segundos</th>
                            <th>anos</th>
                            <th>mes</th>
                            <th>dias</th>
                            <th>id_record</th>
                            <th>promotor</th>
                            <th>Grupo Trabajo</th>
                            <th>dni</th>
                            <th>socio</th>
                            <th>localidad</th>
                            <th>municipio</th>
                            <th>numero_parcela</th>
                            <th>codigo_parcela</th>
                            <th>nombre_parcela</th>
                            <th>anio_inicio_cultivo</th>
                            <th>gps</th>
                            <th>poligono</th>
                            <th>area_gps</th>
                            <th>area_gps_ha</th>
                            <th>are_gps_display</th>
                            <th>instanceID</th>
                            <th>rootUuid</th>
                            <th>inctanceName</th>
                            <th>starttime</th>
                            <th>endtime</th>
                            <th>p_nombre</th>
                            <th>ciclo codigo</th>
                            <th>subscriberid</th>
                            <th>simid</th>
                            <th>formhub uuid</th>
                            <th>version</th>
                            <th>xform id</th>
                            <th>uuid </th>
                            <th>attachments</th>
                            <th>status</th>
                            <th>geolocalización</th>
                            <th>submission_time</th>
                            <th>tags</th>
                            <th>notes</th>
                            <th>validation status</th>
                            <th>submitted by</th>
                            <th>Acciones</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">

    <style>
        .card {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-2px);
        }
        .table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .spinner-custom {
            width: 1rem;
            height: 1rem;
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            max-width: 400px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>


    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


    <script>
        $(document).ready(function() {
        let tabla;

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function initDataTable() {
            tabla = $('#tabla-poligonos').DataTable({
            processing: true,
            scrollX: true,
            serverSide: false,
            dom: 'Bfrtip',
            ajax: {
                url:"<?php echo e(route('georeferenciacion.datatablesactivos')); ?>",
                dataSrc: ""
            },
            columns:[
                {data: 'id'},
                {data: '_id'},
                {data: 'start'},
                {data: 'end'},
                {data: 'today'},
                {data: 'username'},
                {data: 'deviceid'},
                {data: 'phonenumber'},
                {data: 'hora'},
                {data: 'horas'},
                {data: 'minutos'},
                {data: 'segundos'},
                {data: 'anos'},
                {data: 'mes'},
                {data: 'dias'},
                {data: 'id_record'},
                {data: 'promotor'},
                {
                    data: 'grupo_trabajo',
                    defaultContent: 'N/A',
                    render: function(data, type, row) {
                        return data ? data : 'N/A';
                    }
                },
                {data: 'dni'},
                {data: 'socio'},
                {data: 'localidad'},
                {data: 'municipio'},
                {data: 'numero_parcela'},
                {data: 'codigo_parcela'},
                {data: 'nombre_parcela'},
                {data: 'anio_incio_cultivo'},
                {data: 'gps'},
                {data: 'poligono'},
                {data: 'area_gps'},
                {data: 'area_gps_ha'},
                {data: 'area_gps_display'},
                {data: 'meta_instanceID'},
                {data: 'meta_rootUuid'},
                {data: 'meta_instanceName'},
                {data: 'starttime'},
                {data: 'endtime'},
                {data: 'p_nombre'},
                {data: 'ciclo_codigo'},
                {data: 'subscriberid'},
                {data: 'simid'},
                {data: 'formhub_uuid'},
                {data: '__version__'},
                {data: '_xform_id_string'},
                {data: '_uuid'},
                {data: '_attachments'},
                {data: '_status'},
                {data: '_geolocation'},
                {data: '_submission_time'},
                {data: '_tags'},
                {data: '_notes'},
                {data: '_validation_status'},
                {data: '_submitted_by'},
                {
                    data: null,
                    render: function(data, type, row){
                        return `<button class="btn btn-sm btn-primary">Editar</button> 
                                <button class="btn btn-sm btn-danger">Eliminar</button>`;
                    }
                }
            ],
            buttons: [
                {
                    extend:'excelHtml5',
                    text: '<i class="fas fa-file-excel"></i> Excel',
                    className: 'btn btn-success',
                    filename: 'geo_activo_excel',
                    exportOptions:{
                        columns:[8,12,13,14,16,17,18,19,20,21,22,23,24,25,26,27,28,29]
                    }
                }, 
                {
                    text: '<i class="fas fa-file-code"></i> JSON',
                    action: function (e, dt, button, config) {
                        fetch("<?php echo e(route('georeferenciacion.datatablesactivos')); ?>")
                            .then(response => response.json())
                            .then(data => {
                                var jsonStr = JSON.stringify(data, null, 2);
                                
                                var blob = new Blob([jsonStr], { type: 'application/json' });
                                var link = document.createElement('a');
                                link.href = window.URL.createObjectURL(blob);
                                link.download = 'geo_activo_' + new Date().getTime() + '.json';
                                link.click();
                            })
                            .catch(error => {
                                console.error('Error al descargar JSON:', error);
                                alert('Error al descargar el archivo JSON');
                            });
                    }
                }
            ]
                
            });
        }

        $('#toggle-password').on('click', function() {
            const input = $('input[name="second_auth_credential"]');
            const icon = $(this).find('i');
            
            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            } else {
                input.attr('type', 'password');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            }
        });

        $('#btn-verificar').on('click', function() {
            const formData = {
                auth_method: 'basic',
                auth_credential: $('input[name="auth_credential"]').val(),
                second_auth_credential: $('input[name="second_auth_credential"]').val(),
                asset_id: $('input[name="asset_id"]').val(),
                server_url: $('select[name="server_url"]').val(),
                year: $('input[name="year"]').val()
            };

            if (!formData.auth_credential || !formData.second_auth_credential) {
                showNotification('Por favor completa todos los campos requeridos', 'error');
                return;
            }

            const btn = $(this);
            btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Verificando...');

            $.post('/georeferenciacion/info-asset', formData)
                .done(function(response) {
                    if (response.success) {
                        $('#asset-info').removeClass('d-none');
                        $('#asset-details').html(`
                            <strong>Asset:</strong> ${response.name}<br>
                            <strong>Registros:</strong> ${response.deployment_count}<br>
                            <strong>Modificado:</strong> ${response.date_modified ? new Date(response.date_modified).toLocaleString('es-ES') : 'N/A'}
                        `);
                        $('#btn-importar').prop('disabled', false);
                        showNotification('Credenciales verificadas correctamente', 'success');
                    } else {
                        $('#asset-info').addClass('d-none');
                        showNotification('Error: ' + response.message, 'error');
                    }
                })
                .fail(function(xhr) {
                    $('#asset-info').addClass('d-none');
                    const message = xhr.responseJSON?.message || 'Error desconocido';
                    showNotification('Error al verificar: ' + message, 'error');
                })
                .always(function() {
                    btn.prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verificar');
                });
        });

        $('#form-importar').on('submit', function(e) {
            e.preventDefault();
            
            const formData = {
                year: $('input[name="year"]').val(),
                auth_method: 'basic',
                auth_credential: $('input[name="auth_credential"]').val(),
                second_auth_credential: $('input[name="second_auth_credential"]').val(),
                asset_id: $('input[name="asset_id"]').val(),
                server_url: $('select[name="server_url"]').val()
            };

            const btn = $('#btn-importar');
            const spinner = btn.find('.spinner-border');
            
            btn.prop('disabled', true);
            spinner.removeClass('d-none');
            btn.find('i.fa-download').addClass('d-none');
            
            $.post('/georeferenciacion/importar-kobo', formData)
                .done(function(response) {
                    if (response.success) {
                        showNotification(`Importación exitosa: ${response.total} registros importados`, 'success');
                        location.reload();
                    } else {
                        showNotification('Error: ' + response.message, 'error');
                    }
                })
                .fail(function(xhr) {
                    const message = xhr.responseJSON?.message || 'Error desconocido';
                    showNotification('Error en la importación: ' + message, 'error');
                })
                .always(function() {
                    btn.prop('disabled', true);
                    spinner.addClass('d-none');
                    btn.find('i.fa-download').removeClass('d-none');
                });
        });

        $('#filtro-year, #filtro-region, #filtro-municipio, #filtro-estatus, #filtro-activo').on('change', function() {
            const columnIndex = $(this).data('index');
            if (columnIndex !== undefined && tabla) {
                tabla.column(columnIndex).search(this.value).draw();
            }
        });

        $('#btn-limpiar-filtros').on('click', function() {
            $('#filtro-year, #filtro-region, #filtro-municipio, #filtro-estatus, #filtro-activo').val('');
            if (tabla) {
                tabla.columns().search('').draw();
            }
        });

        $('#reload, #btn-actualizar').on('click', function() {
            location.reload();
        });

        $('#btn-exportar').on('click', function() {
            const year = $('#filtro-year').val() || new Date().getFullYear();
            window.open(`/georeferenciacion/exportar?year=${year}`, '_blank');
        });

        $('.ver-detalle').on('click', function() {
            const id = $(this).data('id');
            $('#modal-detalles').modal('show');
        });

        function showNotification(message, type) {
            const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
            const icon = type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-triangle';
            
            const notification = $(`
                <div class="alert ${alertClass} alert-dismissible fade show notification">
                    <i class="${icon} me-2"></i>
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            `);
            
            $('body').append(notification);
            setTimeout(() => notification.alert('close'), 5000);
        }

        initDataTable();
    });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SIC\resources\views/Georeferenciacion/activos.blade.php ENDPATH**/ ?>