<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Portal SIC</title>

        <link href="<?php echo e(asset('img/favicon.ico')); ?>" rel="icon">

        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        <link rel="preconnect" href="https://fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@200;400&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

        <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

        <link href="<?php echo e(asset('lib/owlcarousel/assets/owl.carousel.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('lib/tempusdominus/css/tempusdominus-bootstrap-4.min.css')); ?>" rel="stylesheet">

        <link href="<?php echo e(asset('css/style.min.css')); ?>" rel="stylesheet">

        <!-- Estilos para el carrusel responsivo -->
        <style>
            /* Ajuste del carrusel para pantallas completas */
            .carousel-container {
                position: relative;
                width: 100%;
                overflow: hidden;
                margin-top: 0;
            }
            
            #blog-carousel {
                height: 100vh;
                min-height: 500px;
                max-height: 800px;
            }
            
            #blog-carousel .carousel-inner,
            #blog-carousel .carousel-item {
                height: 100%;
            }
            
            #blog-carousel .carousel-item img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                object-position: center;
            }
            
            /* Overlay para mejor legibilidad del texto */
            .overlay-bottom {
                position: absolute;
                bottom: 0;
                left: 0;
                right: 0;
                background: linear-gradient(to top, rgba(0,0,0,0.7) 0%, rgba(0,0,0,0.3) 50%, transparent 100%);
                padding-bottom: 5rem;
            }
            
            /* Ajustes responsivos para el texto del carrusel */
            .carousel-caption {
                bottom: 20%;
                padding-bottom: 3rem;
            }
            
            .carousel-caption h1.display-1 {
                font-size: 4rem;
                font-weight: 700;
                text-shadow: 2px 2px 8px rgba(0,0,0,0.8);
                margin-bottom: 1rem;
            }
            
            .carousel-caption h2 {
                font-size: 1.8rem;
                text-shadow: 1px 1px 4px rgba(0,0,0,0.8);
            }
            
            /* Responsive para dispositivos móviles */
            @media (max-width: 768px) {
                #blog-carousel {
                    height: 70vh;
                    min-height: 400px;
                }
                
                .carousel-caption {
                    bottom: 15%;
                    padding-bottom: 2rem;
                }
                
                .carousel-caption h1.display-1 {
                    font-size: 2.5rem;
                    margin-bottom: 0.5rem;
                }
                
                .carousel-caption h2 {
                    font-size: 1.2rem;
                }
                
                .carousel-caption .text-primary {
                    font-size: 1.1rem;
                }
            }
            
            @media (max-width: 576px) {
                #blog-carousel {
                    height: 60vh;
                    min-height: 350px;
                }
                
                .carousel-caption {
                    bottom: 10%;
                    padding-bottom: 1rem;
                }
                
                .carousel-caption h1.display-1 {
                    font-size: 2rem;
                }
                
                .carousel-caption h2 {
                    font-size: 1rem;
                }
                
                .carousel-caption .text-primary {
                    font-size: 1rem;
                }
            }
            
            /* Ajuste para el header fijo */
            body {
                padding-top: 0;
            }
            
            header.fixed-top {
                background: transparent;
                transition: background-color 0.3s ease;
            }
            
            header.fixed-top.scrolled {
                background-color: rgba(253, 253, 252, 0.95);
                box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            }
            
            .dark header.fixed-top.scrolled {
                background-color: rgba(10, 10, 10, 0.95);
            }
        </style>

        <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
    </head>
    <body class="bg-[#FDFDFC] dark:bg-[#0a0a0a] text-[#1b1b18]">
        <header class="w-full text-sm fixed-top" style="z-index: 1030;">
            <!-- Navbar similar al login -->
            <nav class="fixed-top">
                <div class="container-fluid d-flex justify-content-between align-items-center py-2">
                    <a href="<?php echo e(route('home')); ?>" class="navbar-brand p-0 m-0">
                        <img src="<?php echo e(asset('vendor/adminlte/dist/img/image.png')); ?>" 
                            alt="Logo" 
                            style="height: 40px; width: auto; margin-left: 15px;">
                    </a>
                    
                    <?php if(Route::has('login')): ?>
                        <div class="flex items-center gap-4 p-2">
                            <?php if(auth()->guard()->check()): ?>
                                <a
                                    href="<?php echo e(url('/dashboard')); ?>"
                                    class="inline-block px-5 py-1.5 dark:text-[#EDEDEC] border-[#19140035] hover:border-[#1915014a] border text-[#1b1b18] dark:border-[#3E3E3A] dark:hover:border-[#62605b] rounded-sm text-sm leading-normal"
                                >
                                    Dashboard
                                </a>
                            <?php else: ?>
                                <a
                                    href="<?php echo e(route('login')); ?>"
                                    class="inline-block px-5 py-1.5 dark:text-[#EDEDEC] text-[#1b1b18] border border-transparent hover:border-[#19140035] dark:hover:border-[#3E3E3A] rounded-sm text-sm leading-normal"
                                >
                                    Log in
                                </a>

                                <?php if(Route::has('register')): ?>
                                    <a
                                        href="<?php echo e(route('register')); ?>"
                                        class="inline-block px-5 py-1.5 dark:text-[#EDEDEC] border-[#19140035] hover:border-[#1915014a] border text-[#1b1b18] dark:border-[#3E3E3A] dark:hover:border-[#62605b] rounded-sm text-sm leading-normal">
                                        Register
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </nav>
        </header>
        
        <!-- Carrusel corregido -->
        <div class="carousel-container">
            <div id="blog-carousel" class="carousel slide" data-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <img class="d-block w-100" src="<?php echo e(asset('img/carousel-1.jpg')); ?>" alt="Imagen 1">
                        <div class="carousel-caption d-flex flex-column align-items-center justify-content-center text-center">
                            <h2 class="text-primary font-weight-medium mb-2">Unión de productores orgánicos</h2>
                            <h1 class="display-1 text-white font-weight-bold mb-2">SIC MAJOMUT</h1>
                            <h2 class="text-white mb-0">Desde 1981</h2>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <img class="d-block w-100" src="<?php echo e(asset('img/carousel-2.jpg')); ?>" alt="Imagen 2">
                        <div class="carousel-caption d-flex flex-column align-items-center justify-content-center text-center">
                            <h2 class="text-primary font-weight-medium mb-2">Unión de productores orgánicos</h2>
                            <h1 class="display-1 text-white font-weight-bold mb-2">SIC MAJOMUT</h1>
                            <h2 class="text-white mb-0">Desde 1981</h2>
                        </div>
                    </div>
                </div>
                <a class="carousel-control-prev" href="#blog-carousel" role="button" data-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="sr-only">Anterior</span>
                </a>
                <a class="carousel-control-next" href="#blog-carousel" role="button" data-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="sr-only">Siguiente</span>
                </a>
            </div>
            <div class="overlay-bottom"></div>
        </div>

        <div class="flex items-center justify-center w-full transition-opacity opacity-100 duration-750 lg:grow starting:opacity-0 py-5">
            <main class="flex max-w-[335px] w-full flex-col-reverse lg:max-w-4xl lg:flex-row">
                <!-- Tu contenido aquí -->
            </main>
        </div>

        <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>
        
        <script src="<?php echo e(asset('lib/easing/easing.min.js')); ?>"></script>
        <script src="<?php echo e(asset('lib/waypoints/waypoints.min.js')); ?>"></script>
        <script src="<?php echo e(asset('lib/owlcarousel/owl.carousel.min.js')); ?>"></script>
        <script src="<?php echo e(asset('lib/tempusdominus/js/moment.min.js')); ?>"></script>
        <script src="<?php echo e(asset('lib/tempusdominus/js/moment-timezone.min.js')); ?>"></script>
        <script src="<?php echo e(asset('lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>

        <script>
            // Script para manejar el scroll del header
            $(document).ready(function() {
                // Configuración del carrusel
                $('#blog-carousel').carousel({
                    interval: 5000,
                    pause: "hover",
                    wrap: true
                });
                
                // Manejar el header al hacer scroll
                $(window).scroll(function() {
                    if ($(this).scrollTop() > 50) {
                        $('header.fixed-top').addClass('scrolled');
                    } else {
                        $('header.fixed-top').removeClass('scrolled');
                    }
                });
                
                // Forzar un redimensionamiento del carrusel al cargar
                function resizeCarousel() {
                    var carousel = $('#blog-carousel');
                    var windowHeight = $(window).height();
                    var headerHeight = $('header').outerHeight();
                    
                    // Ajustar altura del carrusel
                    carousel.css('height', (windowHeight - headerHeight) + 'px');
                    
                    // Ajustar imágenes
                    carousel.find('.carousel-item img').each(function() {
                        $(this).css({
                            'width': '100%',
                            'height': (windowHeight - headerHeight) + 'px',
                            'object-fit': 'cover'
                        });
                    });
                }
                
                // Ejecutar al cargar y redimensionar
                resizeCarousel();
                $(window).resize(resizeCarousel);
            });
        </script>

        <script src="<?php echo e(asset('js/main.js')); ?>"></script>

        <?php echo app('Illuminate\Foundation\Vite')('resources/js/app.js'); ?>
    </body>
</html><?php /**PATH C:\laragon\www\SIC\resources\views/welcome.blade.php ENDPATH**/ ?>